/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderBaseTest;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.InventoryUnavailableException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.PaymentInfoDataProvider;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.SequenceProcessor;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class OrderTest
extends OrderBaseTest {
    private Long orderId = null;
    private int numOrderItems = 0;
    private Long bundleOrderItemId;
    @Resource(name="blOrderItemService")
    private OrderItemService orderItemService;
    @Resource
    private SkuDao skuDao;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blAddItemWorkflow")
    protected SequenceProcessor addItemWorkflow;

    @Test(groups={"createCartForCustomer"}, dependsOnGroups={"readCustomer", "createPhone"})
    @Transactional
    @Rollback(value=false)
    public void createCartForCustomer() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.orderService.createNewCartForCustomer(customer);
        assert (order != null);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"findCurrentCartForCustomer"}, dependsOnGroups={"readCustomer", "createPhone", "createCartForCustomer"})
    @Transactional
    @Rollback(value=false)
    public void findCurrentCartForCustomer() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.orderService.findCartForCustomer(customer);
        assert (order != null);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"addItemToOrder"}, dependsOnGroups={"findCurrentCartForCustomer", "createSku", "testCatalog"})
    @Rollback(value=false)
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addItemToOrder() throws AddToCartException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        OrderItemRequestDTO itemRequest = new OrderItemRequestDTO();
        itemRequest.setQuantity(Integer.valueOf(1));
        itemRequest.setSkuId(sku.getId());
        order = this.orderService.addItem(this.orderId, itemRequest, true);
        DiscreteOrderItem item = (DiscreteOrderItem)this.orderService.findLastMatchingItem(order, sku.getId(), null);
        assert (item != null);
        assert (item.getQuantity() == this.numOrderItems);
        assert (item.getSku() != null);
        assert (item.getSku().equals(sku));
        assert (order.getFulfillmentGroups().size() == 1);
        FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == 1);
        FulfillmentGroupItem fgItem = (FulfillmentGroupItem)fg.getFulfillmentGroupItems().get(0);
        assert (fgItem.getOrderItem().equals(item));
        assert (fgItem.getQuantity() == item.getQuantity());
    }

    @Test(groups={"addAnotherItemToOrder"}, dependsOnGroups={"addItemToOrder"})
    @Rollback(value=false)
    @Transactional
    public void addAnotherItemToOrder() throws AddToCartException {
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        this.orderService.setAutomaticallyMergeLikeItems(true);
        OrderItemRequestDTO itemRequest = new OrderItemRequestDTO();
        itemRequest.setQuantity(Integer.valueOf(1));
        itemRequest.setSkuId(sku.getId());
        order = this.orderService.addItem(this.orderId, itemRequest, true);
        DiscreteOrderItem item = (DiscreteOrderItem)this.orderService.findLastMatchingItem(order, sku.getId(), null);
        assert (item.getSku() != null);
        assert (item.getSku().equals(sku));
        assert (item.getQuantity() == 2);
        order = this.orderService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 1);
        assert (((OrderItem)order.getOrderItems().get(0)).getQuantity() == 2);
        assert (order.getFulfillmentGroups().size() == 1);
        FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == 1);
        FulfillmentGroupItem fgItem = (FulfillmentGroupItem)fg.getFulfillmentGroupItems().get(0);
        assert (fgItem.getOrderItem().equals(item));
        assert (fgItem.getQuantity() == item.getQuantity());
        this.orderService.setAutomaticallyMergeLikeItems(false);
        ++this.numOrderItems;
        itemRequest = new OrderItemRequestDTO();
        itemRequest.setQuantity(Integer.valueOf(1));
        itemRequest.setSkuId(sku.getId());
        order = this.orderService.addItem(this.orderId, itemRequest, true);
        DiscreteOrderItem item2 = (DiscreteOrderItem)this.orderService.findLastMatchingItem(order, sku.getId(), null);
        assert (item2.getSku() != null);
        assert (item2.getSku().equals(sku));
        assert (item2.getQuantity() == 1);
        order = this.orderService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 2);
        assert (((OrderItem)order.getOrderItems().get(0)).getQuantity() == 2);
        assert (((OrderItem)order.getOrderItems().get(1)).getQuantity() == 1);
        assert (order.getFulfillmentGroups().size() == 1);
        fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == 2);
        for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
            assert (fgi.getQuantity() == fgi.getOrderItem().getQuantity());
        }
    }

    @Test(groups={"testIllegalAddScenarios"}, dependsOnGroups={"addItemToOrder"})
    @Transactional
    public void testIllegalAddScenarios() throws AddToCartException {
        boolean addSuccessful;
        block24: {
            OrderItemRequestDTO itemRequest;
            Order order;
            block23: {
                block22: {
                    Product activeProduct;
                    block21: {
                        block20: {
                            Product inactiveProduct;
                            block19: {
                                order = this.orderService.findOrderById(this.orderId);
                                assert (order != null);
                                activeProduct = this.addTestProduct("mug", "cups", true);
                                inactiveProduct = this.addTestProduct("cup", "cups", false);
                                itemRequest = new OrderItemRequestDTO().setQuantity(Integer.valueOf(1)).setSkuId(inactiveProduct.getDefaultSku().getId());
                                addSuccessful = true;
                                try {
                                    order = this.orderService.addItem(this.orderId, itemRequest, true);
                                }
                                catch (AddToCartException e) {
                                    addSuccessful = false;
                                    if ($assertionsDisabled || e.getCause() instanceof InventoryUnavailableException) break block19;
                                    throw new AssertionError();
                                }
                            }
                            assert (!addSuccessful);
                            itemRequest = new OrderItemRequestDTO().setQuantity(Integer.valueOf(1)).setProductId(inactiveProduct.getId());
                            addSuccessful = true;
                            try {
                                order = this.orderService.addItem(this.orderId, itemRequest, true);
                            }
                            catch (AddToCartException e) {
                                addSuccessful = false;
                                if ($assertionsDisabled || e.getCause() instanceof InventoryUnavailableException) break block20;
                                throw new AssertionError();
                            }
                        }
                        assert (!addSuccessful);
                        itemRequest = new OrderItemRequestDTO().setQuantity(Integer.valueOf(-1)).setSkuId(activeProduct.getDefaultSku().getId());
                        addSuccessful = true;
                        try {
                            order = this.orderService.addItem(this.orderId, itemRequest, true);
                        }
                        catch (AddToCartException e) {
                            addSuccessful = false;
                            if ($assertionsDisabled || e.getCause() instanceof IllegalArgumentException) break block21;
                            throw new AssertionError();
                        }
                    }
                    assert (!addSuccessful);
                    itemRequest = new OrderItemRequestDTO().setQuantity(Integer.valueOf(1)).setSkuId(activeProduct.getDefaultSku().getId());
                    addSuccessful = true;
                    try {
                        order = this.orderService.addItem(Long.valueOf(-1L), itemRequest, true);
                    }
                    catch (AddToCartException e) {
                        addSuccessful = false;
                        if ($assertionsDisabled || e.getCause() instanceof IllegalArgumentException) break block22;
                        throw new AssertionError();
                    }
                }
                assert (!addSuccessful);
                itemRequest = new OrderItemRequestDTO().setQuantity(Integer.valueOf(1)).setProductId(Long.valueOf(-1L));
                addSuccessful = true;
                try {
                    order = this.orderService.addItem(this.orderId, itemRequest, true);
                }
                catch (AddToCartException e) {
                    addSuccessful = false;
                    if ($assertionsDisabled || e.getCause() instanceof IllegalArgumentException) break block23;
                    throw new AssertionError();
                }
            }
            assert (!addSuccessful);
            itemRequest = new OrderItemRequestDTO().setQuantity(Integer.valueOf(1)).setSkuId(Long.valueOf(-1L));
            addSuccessful = true;
            try {
                order = this.orderService.addItem(this.orderId, itemRequest, true);
            }
            catch (AddToCartException e) {
                addSuccessful = false;
                if ($assertionsDisabled || e.getCause() instanceof IllegalArgumentException) break block24;
                throw new AssertionError();
            }
        }
        assert (!addSuccessful);
    }

    @Test(groups={"addBundleToOrder"}, dependsOnGroups={"addAnotherItemToOrder"})
    @Rollback(value=false)
    @Transactional
    public void addBundleToOrder() throws AddToCartException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        ProductBundle bundleItem = this.addProductBundle();
        OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setProductId(bundleItem.getId());
        orderItemRequestDTO.setSkuId(bundleItem.getDefaultSku().getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(1));
        order = this.orderService.addItem(order.getId(), orderItemRequestDTO, true);
        BundleOrderItem item = (BundleOrderItem)this.orderService.findLastMatchingItem(order, bundleItem.getDefaultSku().getId(), null);
        this.bundleOrderItemId = item.getId();
        assert (item != null);
        assert (item.getQuantity() == 1);
    }

    @Test(groups={"removeBundleFromOrder"}, dependsOnGroups={"addBundleToOrder"})
    @Rollback(value=false)
    @Transactional
    public void removeBundleFromOrder() throws RemoveFromCartException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() == this.numOrderItems);
        int startingSize = orderItems.size();
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemService.readOrderItemById(this.bundleOrderItemId);
        assert (bundleOrderItem != null);
        assert (bundleOrderItem.getDiscreteOrderItems() != null);
        assert (bundleOrderItem.getDiscreteOrderItems().size() == 1);
        order = this.orderService.removeItem(order.getId(), bundleOrderItem.getId(), true);
        List items = order.getOrderItems();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"getItemsForOrder"}, dependsOnGroups={"removeBundleFromOrder"})
    @Transactional
    public void getItemsForOrder() {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems != null);
        assert (orderItems.size() == this.numOrderItems - 1);
    }

    @Test(groups={"testManyToOneFGItemToOrderItem"}, dependsOnGroups={"getItemsForOrder"})
    @Transactional
    public void testManyToOneFGItemToOrderItem() throws UpdateCartException, RemoveFromCartException, PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        OrderItem item = (OrderItem)orderItems.get(0);
        OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(item.getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(10));
        order = this.orderService.updateItemQuantity(order.getId(), orderItemRequestDTO, true);
        OrderItem updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getQuantity() == 10);
        assert (order.getFulfillmentGroups().size() == 1);
        FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == 2);
        FulfillmentGroupItem fgItem = null;
        for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
            if (!fgi.getOrderItem().equals(updatedItem)) continue;
            fgItem = fgi;
        }
        assert (fgItem != null);
        FulfillmentGroup secondFg = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
        secondFg.setOrder(order);
        secondFg = this.fulfillmentGroupService.save(secondFg);
        fgItem.setQuantity(5);
        FulfillmentGroupItem clonedFgItem = fgItem.clone();
        clonedFgItem.setFulfillmentGroup(secondFg);
        secondFg.addFulfillmentGroupItem(clonedFgItem);
        order.getFulfillmentGroups().add(secondFg);
        order = this.orderService.save(order, Boolean.valueOf(false));
        orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(item.getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(15));
        order = this.orderService.updateItemQuantity(order.getId(), orderItemRequestDTO, true);
        updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getQuantity() == 15);
        assert (order.getFulfillmentGroups().size() == 2);
        int fgItemQuantity = 0;
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgi : fulfillmentGroup.getFulfillmentGroupItems()) {
                if (!fgi.getOrderItem().equals(updatedItem)) continue;
                fgItemQuantity += fgi.getQuantity();
            }
        }
        assert (fgItemQuantity == 15);
        orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(item.getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(3));
        order = this.orderService.updateItemQuantity(order.getId(), orderItemRequestDTO, true);
        updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getQuantity() == 3);
        assert (order.getFulfillmentGroups().size() == 2);
        boolean fgItemFound = false;
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgi : fulfillmentGroup.getFulfillmentGroupItems()) {
                if (!fgi.getOrderItem().equals(updatedItem)) continue;
                assert (!fgItemFound);
                assert (fgi.getQuantity() == 3);
                fgItemFound = true;
            }
        }
        assert (fgItemFound);
    }

    @Test(groups={"updateItemsInOrder"}, dependsOnGroups={"getItemsForOrder"})
    @Transactional
    public void updateItemsInOrder() throws UpdateCartException, RemoveFromCartException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        OrderItem item = (OrderItem)orderItems.get(0);
        OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(item.getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(10));
        order = this.orderService.updateItemQuantity(order.getId(), orderItemRequestDTO, true);
        OrderItem updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getQuantity() == 10);
        assert (order.getFulfillmentGroups().size() == 1);
        FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == 2);
        boolean fgItemUpdated = false;
        for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
            if (!fgi.getOrderItem().equals(updatedItem)) continue;
            assert (fgi.getQuantity() == 10);
            fgItemUpdated = true;
        }
        assert (fgItemUpdated);
        orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(item.getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(5));
        order = this.orderService.updateItemQuantity(order.getId(), orderItemRequestDTO, true);
        updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getQuantity() == 5);
        assert (order.getFulfillmentGroups().size() == 1);
        fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == 2);
        fgItemUpdated = false;
        for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
            if (!fgi.getOrderItem().equals(updatedItem)) continue;
            assert (fgi.getQuantity() == 5);
            fgItemUpdated = true;
        }
        assert (fgItemUpdated);
        int startingSize = order.getOrderItems().size();
        orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(item.getId());
        orderItemRequestDTO.setQuantity(Integer.valueOf(0));
        order = this.orderService.updateItemQuantity(order.getId(), orderItemRequestDTO, true);
        updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem == null);
        assert (order.getOrderItems().size() == startingSize - 1);
        assert (order.getFulfillmentGroups().size() == 1);
        fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg.getFulfillmentGroupItems().size() == startingSize - 1);
        boolean fgItemRemoved = true;
        for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
            if (!fgi.getOrderItem().equals(updatedItem)) continue;
            fgItemRemoved = false;
        }
        assert (fgItemRemoved);
    }

    @Test(groups={"removeItemFromOrder"}, dependsOnGroups={"getItemsForOrder"})
    @Transactional
    public void removeItemFromOrder() throws RemoveFromCartException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        int startingSize = orderItems.size();
        OrderItem item = (OrderItem)orderItems.get(0);
        Long itemId = item.getId();
        assert (item != null);
        order = this.orderService.removeItem(order.getId(), item.getId(), true);
        List items = order.getOrderItems();
        OrderItem updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (items != null);
        assert (items.size() == startingSize - 1);
        assert (updatedItem == null);
    }

    @Test(groups={"checkOrderItems"}, dependsOnGroups={"removeItemFromOrder"})
    @Transactional
    public void checkOrderItems() throws PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 2);
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemService.readOrderItemById(this.bundleOrderItemId);
        assert (bundleOrderItem == null);
    }

    @Test(groups={"getOrdersForCustomer"}, dependsOnGroups={"readCustomer", "findCurrentCartForCustomer"})
    @Transactional
    public void getOrdersForCustomer() {
        String username = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(username);
        List orders = this.orderService.findOrdersForCustomer(customer);
        assert (orders != null);
        assert (orders.size() > 0);
    }

    @Test(groups={"findCartForAnonymousCustomer"}, dependsOnGroups={"getOrdersForCustomer"})
    public void findCartForAnonymousCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.findCartForCustomer(customer);
        assert (order == null);
        order = this.orderService.createNewCartForCustomer(customer);
        Long orderId = order.getId();
        Order newOrder = this.orderService.findOrderById(orderId);
        assert (newOrder != null);
        assert (newOrder.getCustomer() != null);
    }

    @Test(groups={"findOrderByOrderNumber"}, dependsOnGroups={"findCartForAnonymousCustomer"})
    @Transactional
    public void findOrderByOrderNumber() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.createNewCartForCustomer(customer);
        order.setOrderNumber("3456");
        order = this.orderService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order newOrder = this.orderService.findOrderByOrderNumber("3456");
        assert (newOrder.getId().equals(orderId));
        Order nullOrder = this.orderService.findOrderByOrderNumber(null);
        assert (nullOrder == null);
        nullOrder = this.orderService.findOrderByOrderNumber("");
        assert (nullOrder == null);
    }

    @Test(groups={"findNamedOrderForCustomer"}, dependsOnGroups={"findOrderByOrderNumber"})
    @Transactional
    public void findNamedOrderForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.NAMED);
        order.setName("COOL ORDER");
        order = this.orderService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order newOrder = this.orderService.findNamedOrderForCustomer("COOL ORDER", customer);
        assert (newOrder.getId().equals(orderId));
    }

    @Test(groups={"testReadOrdersForCustomer"}, dependsOnGroups={"findNamedOrderForCustomer"})
    @Transactional
    public void testReadOrdersForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.orderService.save(order, Boolean.valueOf(false));
        List newOrders = this.orderService.findOrdersForCustomer(customer, OrderStatus.IN_PROCESS);
        boolean containsOrder = false;
        if (newOrders.contains(order)) {
            containsOrder = true;
        }
        assert (containsOrder);
        containsOrder = false;
        newOrders = this.orderService.findOrdersForCustomer(customer, null);
        if (newOrders.contains(order)) {
            containsOrder = true;
        }
        assert (containsOrder);
    }

    @Test(groups={"testOrderProperties"}, dependsOnGroups={"testReadOrdersForCustomer"})
    public void testOrderProperties() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.createNewCartForCustomer(customer);
        assert (order.getSubTotal() == null);
        assert (order.getTotal() == null);
        assert (order.getRemainingTotal() == null);
        Calendar testCalendar = Calendar.getInstance();
        order.setSubmitDate(testCalendar.getTime());
        assert (order.getSubmitDate().equals(testCalendar.getTime()));
    }

    @Test(groups={"testNamedOrderForCustomer"}, dependsOnGroups={"testOrderProperties"})
    public void testNamedOrderForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer = this.customerService.saveCustomer(customer);
        Order order = this.orderService.createNamedOrderForCustomer("Birthday Order", customer);
        Long orderId = order.getId();
        assert (order != null);
        assert (order.getName().equals("Birthday Order"));
        assert (order.getCustomer().equals(customer));
        this.orderService.cancelOrder(order);
        assert (this.orderService.findOrderById(orderId) == null);
    }

    @Test(groups={"addPaymentToOrder"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class, dependsOnGroups={"checkOrderItems"})
    @Rollback(value=false)
    @Transactional
    public void addPaymentToOrder(PaymentInfo paymentInfo) {
        Order order = this.orderService.findOrderById(this.orderId);
        this.orderService.addPaymentToOrder(order, paymentInfo, null);
        order = this.orderService.findOrderById(this.orderId);
        PaymentInfo payment = (PaymentInfo)order.getPaymentInfos().get(order.getPaymentInfos().indexOf(paymentInfo));
        assert (payment != null);
        assert (payment.getOrder() != null);
        assert (payment.getOrder().equals(order));
    }

    @Test(groups={"testOrderPaymentInfos"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class)
    @Transactional
    public void testOrderPaymentInfos(PaymentInfo info) throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.orderService.createNewCartForCustomer(customer);
        this.orderService.addPaymentToOrder(order, info, null);
        boolean foundInfo = false;
        assert (order.getPaymentInfos() != null);
        for (PaymentInfo testInfo : order.getPaymentInfos()) {
            if (!testInfo.equals(info)) continue;
            foundInfo = true;
        }
        assert (foundInfo);
        assert (this.orderService.findPaymentInfosForOrder(order) != null);
    }

    @Test
    public void findCartForNullCustomerId() {
        assert (this.orderService.findCartForCustomer((Customer)new CustomerImpl()) == null);
    }

    @Test(groups={"testSubmitOrder"}, dependsOnGroups={"findNamedOrderForCustomer"})
    public void testSubmitOrder() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.orderService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order confirmedOrder = this.orderService.confirmOrder(order);
        confirmedOrder = this.orderService.findOrderById(confirmedOrder.getId());
        Long confirmedOrderId = confirmedOrder.getId();
        assert (orderId.equals(confirmedOrderId));
        assert (confirmedOrder.getStatus().equals((Object)OrderStatus.SUBMITTED));
    }
}

