/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.sample.web.controller;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfiguration;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.web.payment.controller.CustomerPaymentGatewayAbstractController;
import org.broadleafcommerce.payment.service.gateway.SamplePaymentGatewayConfiguration;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="blSamplePaymentGatewayCustomerPaymentController")
@RequestMapping(value={"/sample-customer-payment"})
public class SamplePaymentGatewayCustomerPaymentController
extends CustomerPaymentGatewayAbstractController {
    protected static final Log LOG = LogFactory.getLog(SamplePaymentGatewayCustomerPaymentController.class);
    protected static final String GATEWAY_CONTEXT_KEY = "sample-customer-payment";
    protected static final String CUSTOMER_PAYMENT_ERROR = "CUSTOMER_PAYMENT_ERROR";
    protected static String customerPaymentErrorMessage = "customerPaymentErrorMessage";
    @Resource(name="blSamplePaymentGatewayWebResponseService")
    protected PaymentGatewayWebResponseService paymentGatewayWebResponseService;
    @Resource(name="blSamplePaymentGatewayConfiguration")
    protected SamplePaymentGatewayConfiguration paymentGatewayConfiguration;

    public PaymentGatewayWebResponseService getWebResponseService() {
        return this.paymentGatewayWebResponseService;
    }

    public PaymentGatewayConfiguration getConfiguration() {
        return this.paymentGatewayConfiguration;
    }

    public String getCustomerPaymentViewRedirect(String customerPaymentId) {
        return "redirect:/account/payment/" + customerPaymentId;
    }

    public String getCustomerPaymentErrorRedirect() {
        return "redirect:/account/payment";
    }

    public void handleProcessingException(Exception e, RedirectAttributes redirectAttributes) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"A Processing Exception Occurred for sample-customer-payment. Adding Error to Redirect Attributes.");
        }
        redirectAttributes.addAttribute(CUSTOMER_PAYMENT_ERROR, (Object)customerPaymentErrorMessage);
    }

    @RequestMapping(value={"/return"}, method={RequestMethod.POST})
    public String returnEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, Map<String, String> pathVars) throws PaymentException {
        return super.createCustomerPayment(model, request, redirectAttributes);
    }

    @RequestMapping(value={"/error"}, method={RequestMethod.GET})
    public String errorEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, Map<String, String> pathVars) throws PaymentException {
        redirectAttributes.addAttribute(CUSTOMER_PAYMENT_ERROR, (Object)request.getParameter(CUSTOMER_PAYMENT_ERROR));
        return this.getCustomerPaymentErrorRedirect();
    }
}

