/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.sample.service.payment;

import java.util.LinkedHashMap;
import java.util.Map;

public class PaymentTransactionType
extends org.broadleafcommerce.common.payment.PaymentTransactionType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PaymentTransactionType> TYPES = new LinkedHashMap<String, PaymentTransactionType>();
    public static final PaymentTransactionType CREATE_CUSTOMER = new PaymentTransactionType("CREATE_CUSTOMER", "Create Customer");
    public static final PaymentTransactionType UPDATE_CUSTOMER = new PaymentTransactionType("UPDATE_CUSTOMER", "Update Customer");
    public static final PaymentTransactionType DELETE_CUSTOMER = new PaymentTransactionType("DELETE_CUSTOMER", "Delete Customer");
    private String type;
    private String friendlyType;

    public static PaymentTransactionType getInstance(String type) {
        return TYPES.get(type);
    }

    public PaymentTransactionType() {
    }

    public PaymentTransactionType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    protected void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PaymentTransactionType other = (PaymentTransactionType)((Object)obj);
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

