/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.sample.web.controller.mock.processor;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.broadleafcommerce.common.util.StringUtil;
import org.broadleafcommerce.payment.service.gateway.SamplePaymentGatewayHostedConfiguration;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="blSampleMockHostedProcessorController")
public class SampleMockHostedProcessorController {
    @Resource(name="blSamplePaymentGatewayHostedConfiguration")
    protected SamplePaymentGatewayHostedConfiguration paymentGatewayConfiguration;

    @RequestMapping(value={"/hosted/sample-checkout"}, method={RequestMethod.POST})
    @ResponseBody
    public String retrieveHostedEndpoint(HttpServletRequest request) {
        String[] completeCheckoutOnCallbackParam;
        String[] orderIdParam;
        Map paramMap = request.getParameterMap();
        String transactionAmount = "";
        String orderId = "";
        String completeCheckoutOnCallback = "true";
        String resultMessage = "Hosted Call Successful";
        String[] transactionAmountParam = (String[])paramMap.get("TRANSACTION_AMT");
        if (transactionAmountParam != null && transactionAmountParam.length > 0) {
            transactionAmount = StringUtil.sanitize((String)transactionAmountParam[0]);
        }
        if ((orderIdParam = (String[])paramMap.get("ORDER_ID")) != null && orderIdParam.length > 0) {
            orderId = StringUtil.sanitize((String)orderIdParam[0]);
        }
        if ((completeCheckoutOnCallbackParam = (String[])paramMap.get("COMPLETE_CHECKOUT_ON_CALLBACK")) != null && completeCheckoutOnCallbackParam.length > 0) {
            completeCheckoutOnCallback = StringUtil.sanitize((String)completeCheckoutOnCallbackParam[0]);
        }
        StringBuffer response = new StringBuffer();
        response.append("<!DOCTYPE HTML>");
        response.append("<!--[if lt IE 7]> <html class=\"no-js lt-ie9 lt-ie8 lt-ie7\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if IE 7]> <html class=\"no-js lt-ie9 lt-ie8\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if IE 8]> <html class=\"no-js lt-ie9\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if gt IE 8]><!--> <html class=\"no-js\" lang=\"en\"> <!--<![endif]-->");
        response.append("<body>");
        response.append("<h1>Mock Hosted Checkout</h1>");
        response.append("<p>This is an example that demonstrates the flow of a Hosted Third Party Checkout Integration (e.g. PayPal Express Checkout)</p>");
        response.append("<p>This customer will be prompted to either enter their credentials or fill out their payment information. Once complete, they will be redirected back to either a confirmation page or a review page to complete checkout.</p>");
        response.append("<form action=\"" + this.paymentGatewayConfiguration.getHostedRedirectReturnUrl() + "\" method=\"GET\" id=\"SamplePaymentGatewayRedirectForm\" name=\"SamplePaymentGatewayRedirectForm\">");
        response.append("<input type=\"hidden\" name=\"TRANSACTION_AMT\" value=\"" + transactionAmount + "\"/>");
        response.append("<input type=\"hidden\" name=\"ORDER_ID\" value=\"" + orderId + "\"/>");
        response.append("<input type=\"hidden\" name=\"COMPLETE_CHECKOUT_ON_CALLBACK\" value=\"" + completeCheckoutOnCallback + "\"/>");
        response.append("<input type=\"hidden\" name=\"MESSAGE\" value=\"" + resultMessage + "\"/>");
        response.append("<input type=\"submit\" value=\"Please Click Here To Complete Checkout\"/>");
        response.append("</form>");
        response.append("</body>");
        response.append("</html>");
        return response.toString();
    }
}

