/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.sample.web.controller.mock.processor;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.CreditCardValidator;
import org.broadleafcommerce.common.util.StringUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="blSampleMockCustomerPaymentProcessorController")
public class SampleMockCustomerPaymentProcessorController {
    @RequestMapping(value={"/sample-customer-payment/process"}, method={RequestMethod.POST})
    @ResponseBody
    public String processTransparentRedirectForm(HttpServletRequest request) {
        String[] creditCardCvvParam;
        String[] creditCardExpDateParam;
        String[] creditCardNumberParam;
        String[] creditCardNameParam;
        String[] billingCompanyNameParam;
        String[] billingEmailParam;
        String[] billingPhoneParam;
        String[] shippingCountryParam;
        String[] shippingZipParam;
        String[] shippingStateParam;
        String[] shippingCityParam;
        String[] shippingAddressLine2Param;
        String[] shippingAddressLine1Param;
        String[] shippingLastNameParam;
        String[] shippingFirstNameParam;
        String[] billingCountryParam;
        String[] billingZipParam;
        String[] billingStateParam;
        String[] billingCityParam;
        String[] billingAddressLine2Param;
        String[] billingAddressLine1Param;
        String[] billingLastNameParam;
        String[] billingFirstNameParam;
        String[] customerIdParam;
        Map paramMap = request.getParameterMap();
        String returnUrl = "";
        String customerId = "";
        String billingFirstName = "";
        String billingLastName = "";
        String billingAddressLine1 = "";
        String billingAddressLine2 = "";
        String billingCity = "";
        String billingState = "";
        String billingZip = "";
        String billingCountry = "";
        String shippingFirstName = "";
        String shippingLastName = "";
        String shippingAddressLine1 = "";
        String shippingAddressLine2 = "";
        String shippingCity = "";
        String shippingState = "";
        String shippingZip = "";
        String shippingCountry = "";
        String emailAddress = "";
        String companyName = "";
        String billingPhone = "";
        String creditCardName = "";
        String creditCardNumber = "";
        String creditCardExpDate = "";
        String creditCardCVV = "";
        String cardType = "UNKNOWN";
        String resultMessage = "";
        String resultSuccess = "";
        String paymentTokenId = UUID.randomUUID().toString();
        String validUrlRegex = "\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String[] transparentRedirectReturnUrlParam = (String[])paramMap.get("TRANSPARENT_REDIRECT_RETURN_URL");
        if (transparentRedirectReturnUrlParam != null && transparentRedirectReturnUrlParam.length > 0) {
            if (!transparentRedirectReturnUrlParam[0].matches(validUrlRegex)) {
                throw new IllegalArgumentException("Redirect Return URL is not a valid URL");
            }
            returnUrl = transparentRedirectReturnUrlParam[0];
        }
        if ((customerIdParam = (String[])paramMap.get("CUSTOMER_ID")) != null && customerIdParam.length > 0) {
            customerId = StringUtil.sanitize((String)customerIdParam[0]);
        }
        if ((billingFirstNameParam = (String[])paramMap.get("NULL_BILLING_FIRST_NAME")) != null && billingFirstNameParam.length > 0) {
            billingFirstName = StringUtil.sanitize((String)billingFirstNameParam[0]);
        }
        if ((billingLastNameParam = (String[])paramMap.get("NULL_BILLING_LAST_NAME")) != null && billingLastNameParam.length > 0) {
            billingLastName = StringUtil.sanitize((String)billingLastNameParam[0]);
        }
        if ((billingAddressLine1Param = (String[])paramMap.get("NULL_BILLING_ADDRESS_LINE1")) != null && billingAddressLine1Param.length > 0) {
            billingAddressLine1 = StringUtil.sanitize((String)billingAddressLine1Param[0]);
        }
        if ((billingAddressLine2Param = (String[])paramMap.get("NULL_BILLING_ADDRESS_LINE2")) != null && billingAddressLine2Param.length > 0) {
            billingAddressLine2 = StringUtil.sanitize((String)billingAddressLine2Param[0]);
        }
        if ((billingCityParam = (String[])paramMap.get("NULL_BILLING_CITY")) != null && billingCityParam.length > 0) {
            billingCity = StringUtil.sanitize((String)billingCityParam[0]);
        }
        if ((billingStateParam = (String[])paramMap.get("NULL_BILLING_STATE")) != null && billingStateParam.length > 0) {
            billingState = StringUtil.sanitize((String)billingStateParam[0]);
        }
        if ((billingZipParam = (String[])paramMap.get("NULL_BILLING_ZIP")) != null && billingZipParam.length > 0) {
            billingZip = StringUtil.sanitize((String)billingZipParam[0]);
        }
        if ((billingCountryParam = (String[])paramMap.get("NULL_BILLING_COUNTRY")) != null && billingCountryParam.length > 0) {
            billingCountry = StringUtil.sanitize((String)billingCountryParam[0]);
        }
        if ((shippingFirstNameParam = (String[])paramMap.get("NULL_SHIPPING_FIRST_NAME")) != null && shippingFirstNameParam.length > 0) {
            shippingFirstName = StringUtil.sanitize((String)shippingFirstNameParam[0]);
        }
        if ((shippingLastNameParam = (String[])paramMap.get("NULL_SHIPPING_LAST_NAME")) != null && shippingLastNameParam.length > 0) {
            shippingLastName = StringUtil.sanitize((String)shippingLastNameParam[0]);
        }
        if ((shippingAddressLine1Param = (String[])paramMap.get("NULL_SHIPPING_ADDRESS_LINE1")) != null && shippingAddressLine1Param.length > 0) {
            shippingAddressLine1 = StringUtil.sanitize((String)shippingAddressLine1Param[0]);
        }
        if ((shippingAddressLine2Param = (String[])paramMap.get("NULL_SHIPPING_ADDRESS_LINE2")) != null && shippingAddressLine2Param.length > 0) {
            shippingAddressLine2 = StringUtil.sanitize((String)shippingAddressLine2Param[0]);
        }
        if ((shippingCityParam = (String[])paramMap.get("NULL_SHIPPING_CITY")) != null && shippingCityParam.length > 0) {
            shippingCity = StringUtil.sanitize((String)shippingCityParam[0]);
        }
        if ((shippingStateParam = (String[])paramMap.get("NULL_SHIPPING_STATE")) != null && shippingStateParam.length > 0) {
            shippingState = StringUtil.sanitize((String)shippingStateParam[0]);
        }
        if ((shippingZipParam = (String[])paramMap.get("NULL_SHIPPING_ZIP")) != null && shippingZipParam.length > 0) {
            shippingZip = StringUtil.sanitize((String)shippingZipParam[0]);
        }
        if ((shippingCountryParam = (String[])paramMap.get("NULL_SHIPPING_COUNTRY")) != null && shippingCountryParam.length > 0) {
            shippingCountry = StringUtil.sanitize((String)shippingCountryParam[0]);
        }
        if ((billingPhoneParam = (String[])paramMap.get("NULL_BILLING_PHONE")) != null && billingPhoneParam.length > 0) {
            billingPhone = billingPhoneParam[0];
        }
        if ((billingEmailParam = (String[])paramMap.get("NULL_BILLING_EMAIL")) != null && billingEmailParam.length > 0) {
            emailAddress = billingEmailParam[0];
        }
        if ((billingCompanyNameParam = (String[])paramMap.get("NULL_BILLING_COMPANY_NAME")) != null && billingCompanyNameParam.length > 0) {
            companyName = billingCompanyNameParam[0];
        }
        if ((creditCardNameParam = (String[])paramMap.get("CREDIT_CARD_NAME")) != null && creditCardNameParam.length > 0) {
            creditCardName = StringUtil.sanitize((String)creditCardNameParam[0]);
        }
        if ((creditCardNumberParam = (String[])paramMap.get("CREDIT_CARD_NUMBER")) != null && creditCardNumberParam.length > 0) {
            creditCardNumber = StringUtil.sanitize((String)creditCardNumberParam[0]);
        }
        if ((creditCardExpDateParam = (String[])paramMap.get("CREDIT_CARD_EXP_DATE")) != null && creditCardExpDateParam.length > 0) {
            creditCardExpDate = creditCardExpDateParam[0];
        }
        if ((creditCardCvvParam = (String[])paramMap.get("CREDIT_CARD_CVV")) != null && creditCardCvvParam.length > 0) {
            creditCardCVV = StringUtil.sanitize((String)creditCardCvvParam[0]);
        }
        CreditCardValidator visaValidator = new CreditCardValidator(2);
        CreditCardValidator amexValidator = new CreditCardValidator(1);
        CreditCardValidator mcValidator = new CreditCardValidator(4);
        CreditCardValidator discoverValidator = new CreditCardValidator(8);
        if (StringUtils.isNotBlank((String)creditCardNumber) && StringUtils.isNotBlank((String)creditCardExpDate)) {
            boolean validCard = false;
            if (visaValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "VISA";
            } else if (amexValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "AMEX";
            } else if (mcValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "MASTERCARD";
            } else if (discoverValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "DISCOVER";
            }
            boolean validDateFormat = false;
            boolean validDate = false;
            String[] parsedDate = creditCardExpDate.split("/");
            if (parsedDate.length == 2) {
                String expMonth = StringUtil.sanitize((String)parsedDate[0]);
                String expYear = StringUtil.sanitize((String)parsedDate[1]);
                ZoneId zone = ZoneId.systemDefault();
                try {
                    ZonedDateTime expirationDate = ZonedDateTime.of(Integer.parseInt(expYear), Integer.parseInt(expMonth), 1, 0, 0, 0, 0, zone);
                    LocalDateTime expDate = expirationDate.toInstant().atZone(zone).toLocalDateTime();
                    validDate = expDate.isAfter(LocalDateTime.now());
                    validDateFormat = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!validDate || !validDateFormat) {
                resultMessage = "customer.payment.expiration.invalid";
                resultSuccess = "false";
            } else if (!validCard) {
                resultMessage = "customer.payment.card.invalid";
                resultSuccess = "false";
            } else {
                resultMessage = "Success!";
                resultSuccess = "true";
            }
        } else {
            resultMessage = "customer.payment.invalid";
            resultSuccess = "false";
        }
        StringBuffer response = new StringBuffer();
        response.append("<!DOCTYPE HTML>");
        response.append("<!--[if lt IE 7]> <html class=\"no-js lt-ie9 lt-ie8 lt-ie7\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if IE 7]> <html class=\"no-js lt-ie9 lt-ie8\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if IE 8]> <html class=\"no-js lt-ie9\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if gt IE 8]><!--> <html class=\"no-js\" lang=\"en\"> <!--<![endif]-->");
        response.append("<body>");
        response.append("<form action=\"" + returnUrl + "\" method=\"POST\" id=\"SamplePaymentGatewayRedirectForm\" name=\"SamplePaymentGatewayRedirectForm\">");
        response.append("<input type=\"hidden\" name=\"CUSTOMER_ID\" value=\"" + customerId + "\"/>");
        response.append("<input type=\"hidden\" name=\"MESSAGE\" value=\"" + resultMessage + "\"/>");
        response.append("<input type=\"hidden\" name=\"SUCCESS\" value=\"" + resultSuccess + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_FIRST_NAME\" value=\"" + billingFirstName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_LAST_NAME\" value=\"" + billingLastName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_ADDRESS_LINE1\" value=\"" + billingAddressLine1 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_ADDRESS_LINE2\" value=\"" + billingAddressLine2 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_CITY\" value=\"" + billingCity + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_STATE\" value=\"" + billingState + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_ZIP\" value=\"" + billingZip + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_COUNTRY\" value=\"" + billingCountry + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_FIRST_NAME\" value=\"" + shippingFirstName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_LAST_NAME\" value=\"" + shippingLastName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_ADDRESS_LINE1\" value=\"" + shippingAddressLine1 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_ADDRESS_LINE2\" value=\"" + shippingAddressLine2 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_CITY\" value=\"" + shippingCity + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_STATE\" value=\"" + shippingState + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_ZIP\" value=\"" + shippingZip + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_COUNTRY\" value=\"" + shippingCountry + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_PHONE\" value=\"" + billingPhone + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_EMAIL\" value=\"" + emailAddress + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_COMPANY_NAME\" value=\"" + companyName + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_NAME\" value=\"" + creditCardName + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_LAST_FOUR\" value=\"" + StringUtils.right((String)creditCardNumber, (int)4) + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_TYPE\" value=\"" + cardType + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_EXP_DATE\" value=\"" + creditCardExpDate + "\"/>");
        response.append("<input type=\"hidden\" name=\"PAYMENT_TOKEN_ID\" value=\"" + paymentTokenId + "\"/>");
        response.append("<input type=\"submit\" value=\"Please Click Here To Complete New Payment\"/>");
        response.append("</form>");
        response.append("<script type=\"text/javascript\">");
        response.append("document.getElementById('SamplePaymentGatewayRedirectForm').submit();");
        response.append("</script>");
        response.append("</body>");
        response.append("</html>");
        return response.toString();
    }
}

