/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.sample.web.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayHostedService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.presentation.condition.ConditionalOnTemplating;
import org.broadleafcommerce.presentation.dialect.AbstractBroadleafAttributeModifierProcessor;
import org.broadleafcommerce.presentation.model.BroadleafAttributeModifier;
import org.broadleafcommerce.presentation.model.BroadleafTemplateContext;
import org.springframework.stereotype.Component;

@Component(value="blSamplePaymentGatewayHostedActionProcessor")
@ConditionalOnTemplating
public class SamplePaymentGatewayHostedActionProcessor
extends AbstractBroadleafAttributeModifierProcessor {
    @Resource(name="blSamplePaymentGatewayHostedService")
    private PaymentGatewayHostedService paymentGatewayHostedService;

    public String getName() {
        return "sample_payment_hosted_action";
    }

    public int getPrecedence() {
        return 10000;
    }

    public BroadleafAttributeModifier getModifiedAttributes(String tagName, Map<String, String> tagAttributes, String attributeName, String attributeValue, BroadleafTemplateContext context) {
        PaymentRequestDTO requestDTO = (PaymentRequestDTO)context.parseExpression(attributeValue);
        String url = "";
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        ArrayList<String> removedAttributes = new ArrayList<String>();
        if (requestDTO != null) {
            if (tagAttributes.get("complete_checkout") != null) {
                Boolean completeCheckout = (Boolean)context.parseExpression(tagAttributes.get("complete_checkout"));
                removedAttributes.add("complete_checkout");
                requestDTO.completeCheckoutOnCallback(completeCheckout.booleanValue());
            }
            try {
                PaymentResponseDTO responseDTO = this.paymentGatewayHostedService.requestHostedEndpoint(requestDTO);
                url = ((String)responseDTO.getResponseMap().get("HOSTED_REDIRECT_URL")).toString();
            }
            catch (PaymentException e) {
                throw new RuntimeException("Unable to Create Sample Payment Gateway Hosted Link", e);
            }
        }
        newAttributes.put("action", url);
        return new BroadleafAttributeModifier(newAttributes, removedAttributes);
    }
}

