/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.i18n.domain.ISOCountry;
import org.broadleafcommerce.common.i18n.domain.ISOCountryImpl;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.common.time.domain.TemporalTimestampListener;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ADDRESS")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="phonePrimary", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phoneSecondary", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phoneFax", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="phonePrimary.phoneNumber", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=false), @AdminPresentationMergeEntry(propertyType="order", intOverrideValue=1300), @AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="NOT_REQUIRED"), @AdminPresentationMergeEntry(propertyType="friendlyName", overrideValue="PhoneImpl_Primary_Phone")}), @AdminPresentationMergeOverride(name="phoneSecondary.phoneNumber", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=false), @AdminPresentationMergeEntry(propertyType="order", intOverrideValue=1400), @AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="NOT_REQUIRED"), @AdminPresentationMergeEntry(propertyType="friendlyName", overrideValue="PhoneImpl_Secondary_Phone")}), @AdminPresentationMergeOverride(name="phoneFax.phoneNumber", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=false), @AdminPresentationMergeEntry(propertyType="order", intOverrideValue=1500), @AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="NOT_REQUIRED"), @AdminPresentationMergeEntry(propertyType="friendlyName", overrideValue="PhoneImpl_Fax_Phone")}), @AdminPresentationMergeOverride(name="state", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="country", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)})})
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="AddressImpl_baseAddress")
public class AddressImpl
implements Address {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="AddressId")
    @GenericGenerator(name="AddressId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="AddressImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.profile.core.domain.AddressImpl")})
    @Column(name="ADDRESS_ID")
    protected Long id;
    @Column(name="FULL_NAME")
    @AdminPresentation(friendlyName="AddressImpl_Full_Name", order=10, group="AddressImpl_Address")
    protected String fullName;
    @Column(name="FIRST_NAME")
    @AdminPresentation(friendlyName="AddressImpl_First_Name", order=10, group="AddressImpl_Address")
    protected String firstName;
    @Column(name="LAST_NAME")
    @AdminPresentation(friendlyName="AddressImpl_Last_Name", order=20, group="AddressImpl_Address")
    protected String lastName;
    @Column(name="EMAIL_ADDRESS")
    @AdminPresentation(friendlyName="AddressImpl_Email_Address", order=30, group="AddressImpl_Address")
    protected String emailAddress;
    @Column(name="COMPANY_NAME")
    @AdminPresentation(friendlyName="AddressImpl_Company_Name", order=40, group="AddressImpl_Address")
    protected String companyName;
    @Column(name="ADDRESS_LINE1", nullable=false)
    @AdminPresentation(friendlyName="AddressImpl_Address_1", order=50, group="AddressImpl_Address")
    protected String addressLine1;
    @Column(name="ADDRESS_LINE2")
    @AdminPresentation(friendlyName="AddressImpl_Address_2", order=60, group="AddressImpl_Address")
    protected String addressLine2;
    @Column(name="ADDRESS_LINE3")
    @AdminPresentation(friendlyName="AddressImpl_Address_3", order=60, group="AddressImpl_Address")
    protected String addressLine3;
    @Column(name="CITY", nullable=false)
    @AdminPresentation(friendlyName="AddressImpl_City", order=70, group="AddressImpl_Address")
    protected String city;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=StateImpl.class)
    @JoinColumn(name="STATE_PROV_REGION")
    @Index(name="ADDRESS_STATE_INDEX", columnNames={"STATE_PROV_REGION"})
    @AdminPresentation(friendlyName="StateImpl_State", order=70, group="AddressImpl_Address", prominent=true)
    @Deprecated
    protected State state;
    @Column(name="ISO_COUNTRY_SUB")
    @AdminPresentation(friendlyName="AddressImpl_Country_Subdivision", order=110, group="AddressImpl_Address", tooltip="AddressImpl_Country_Subdivision_ToolTip")
    protected String isoCountrySubdivision;
    @Column(name="SUB_STATE_PROV_REG")
    @AdminPresentation(friendlyName="AddressImpl_State_Province_Region", order=80, group="AddressImpl_Address")
    protected String stateProvinceRegion;
    @Column(name="COUNTY")
    @AdminPresentation(friendlyName="AddressImpl_County", order=90, group="AddressImpl_Address")
    protected String county;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CountryImpl.class)
    @JoinColumn(name="COUNTRY")
    @Index(name="ADDRESS_COUNTRY_INDEX", columnNames={"COUNTRY"})
    @AdminPresentation(friendlyName="CountryImpl_Country", order=100, group="AddressImpl_Address", prominent=true, translatable=true)
    @Deprecated
    protected Country country;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=ISOCountryImpl.class)
    @JoinColumn(name="ISO_COUNTRY_ALPHA2")
    @Index(name="ADDRESS_ISO_COUNTRY_IDX", columnNames={"ISO_COUNTRY_ALPHA2"})
    @AdminPresentation(friendlyName="AddressImpl_Country_Alpha2", order=100, group="AddressImpl_Address")
    @AdminPresentationToOneLookup
    protected ISOCountry isoCountryAlpha2;
    @Column(name="POSTAL_CODE")
    @AdminPresentation(friendlyName="AddressImpl_Postal_Code", order=120, group="AddressImpl_Address")
    protected String postalCode;
    @Column(name="ZIP_FOUR")
    @AdminPresentation(friendlyName="AddressImpl_Four_Digit_Zip", order=130, group="AddressImpl_Address")
    protected String zipFour;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_PRIMARY_ID")
    @Index(name="ADDRESS_PHONE_PRI_IDX", columnNames={"PHONE_PRIMARY_ID"})
    protected Phone phonePrimary;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_SECONDARY_ID")
    @Index(name="ADDRESS_PHONE_SEC_IDX", columnNames={"PHONE_SECONDARY_ID"})
    protected Phone phoneSecondary;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_FAX_ID")
    @Index(name="ADDRESS_PHONE_FAX_IDX", columnNames={"PHONE_FAX_ID"})
    protected Phone phoneFax;
    @Column(name="IS_DEFAULT")
    @AdminPresentation(friendlyName="AddressImpl_Default_Address", order=160, group="AddressImpl_Address")
    protected boolean isDefault = false;
    @Column(name="IS_ACTIVE")
    @AdminPresentation(friendlyName="AddressImpl_Active_Address", order=170, group="AddressImpl_Address")
    protected boolean isActive = true;
    @Column(name="IS_BUSINESS")
    @AdminPresentation(friendlyName="AddressImpl_Business_Address", order=180, group="AddressImpl_Address")
    protected boolean isBusiness = false;
    @Column(name="IS_STREET")
    @AdminPresentation(friendlyName="AddressImpl_Street_Address", order=220, group="AddressImpl_Address")
    protected boolean isStreet = false;
    @Column(name="IS_MAILING")
    @AdminPresentation(friendlyName="AddressImpl_Mailing_Address", order=230, group="AddressImpl_Address")
    protected boolean isMailing = false;
    @Column(name="TOKENIZED_ADDRESS")
    @AdminPresentation(friendlyName="AddressImpl_Tokenized_Address", order=190, group="AddressImpl_Address", visibility=VisibilityEnum.HIDDEN_ALL)
    protected String tokenizedAddress;
    @Column(name="STANDARDIZED")
    @AdminPresentation(friendlyName="AddressImpl_Standardized", order=200, group="AddressImpl_Address", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean standardized = Boolean.FALSE;
    @Column(name="VERIFICATION_LEVEL")
    @AdminPresentation(friendlyName="AddressImpl_Verification_Level", order=210, group="AddressImpl_Address", visibility=VisibilityEnum.HIDDEN_ALL)
    protected String verificationLevel;
    @Column(name="PRIMARY_PHONE")
    @Deprecated
    protected String primaryPhone;
    @Column(name="SECONDARY_PHONE")
    @Deprecated
    protected String secondaryPhone;
    @Column(name="FAX")
    @Deprecated
    protected String fax;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Override
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    @Override
    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Override
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    @Override
    public String getAddressLine3() {
        return this.addressLine3;
    }

    @Override
    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    @Override
    @Deprecated
    public Country getCountry() {
        return this.country;
    }

    @Override
    @Deprecated
    public void setCountry(Country country) {
        this.country = country;
    }

    @Override
    public String getIsoCountrySubdivision() {
        return this.isoCountrySubdivision;
    }

    @Override
    public void setIsoCountrySubdivision(String isoCountrySubdivision) {
        this.isoCountrySubdivision = isoCountrySubdivision;
    }

    @Override
    public String getStateProvinceRegion() {
        return this.stateProvinceRegion;
    }

    @Override
    public void setStateProvinceRegion(String stateProvinceRegion) {
        this.stateProvinceRegion = stateProvinceRegion;
    }

    @Override
    public ISOCountry getIsoCountryAlpha2() {
        return this.isoCountryAlpha2;
    }

    @Override
    public void setIsoCountryAlpha2(ISOCountry isoCountryAlpha2) {
        this.isoCountryAlpha2 = isoCountryAlpha2;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public String getCounty() {
        return this.county;
    }

    @Override
    public void setCounty(String county) {
        this.county = county;
    }

    @Override
    @Deprecated
    public State getState() {
        return this.state;
    }

    @Override
    @Deprecated
    public void setState(State state) {
        this.state = state;
    }

    @Override
    public String getTokenizedAddress() {
        return this.tokenizedAddress;
    }

    @Override
    public void setTokenizedAddress(String tokenizedAddress) {
        this.tokenizedAddress = tokenizedAddress;
    }

    @Override
    public Boolean getStandardized() {
        return this.standardized;
    }

    @Override
    public void setStandardized(Boolean standardized) {
        this.standardized = standardized;
    }

    @Override
    public String getZipFour() {
        return this.zipFour;
    }

    @Override
    public void setZipFour(String zipFour) {
        this.zipFour = zipFour;
    }

    @Override
    public String getCompanyName() {
        return this.companyName;
    }

    @Override
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    @Deprecated
    public String getPrimaryPhone() {
        return this.primaryPhone;
    }

    @Override
    @Deprecated
    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    @Override
    @Deprecated
    public String getSecondaryPhone() {
        return this.secondaryPhone;
    }

    @Override
    @Deprecated
    public void setSecondaryPhone(String secondaryPhone) {
        this.secondaryPhone = secondaryPhone;
    }

    @Override
    @Deprecated
    public String getFax() {
        return this.fax;
    }

    @Override
    @Deprecated
    public void setFax(String fax) {
        this.fax = fax;
    }

    @Override
    public Phone getPhonePrimary() {
        PhoneImpl legacyPhone = new PhoneImpl();
        legacyPhone.setPhoneNumber(this.primaryPhone);
        return this.phonePrimary == null && this.primaryPhone != null ? legacyPhone : this.phonePrimary;
    }

    @Override
    public void setPhonePrimary(Phone phonePrimary) {
        this.phonePrimary = phonePrimary;
    }

    @Override
    public Phone getPhoneSecondary() {
        PhoneImpl legacyPhone = new PhoneImpl();
        legacyPhone.setPhoneNumber(this.secondaryPhone);
        return this.phoneSecondary == null && this.secondaryPhone != null ? legacyPhone : this.phoneSecondary;
    }

    @Override
    public void setPhoneSecondary(Phone phoneSecondary) {
        this.phoneSecondary = phoneSecondary;
    }

    @Override
    public Phone getPhoneFax() {
        PhoneImpl legacyPhone = new PhoneImpl();
        legacyPhone.setPhoneNumber(this.fax);
        return this.phoneFax == null && this.fax != null ? legacyPhone : this.phoneFax;
    }

    @Override
    public void setPhoneFax(Phone phoneFax) {
        this.phoneFax = phoneFax;
    }

    @Override
    public boolean isBusiness() {
        return this.isBusiness;
    }

    @Override
    public void setBusiness(boolean isBusiness) {
        this.isBusiness = isBusiness;
    }

    @Override
    public boolean isStreet() {
        return this.isStreet;
    }

    @Override
    public void setStreet(boolean isStreet) {
        this.isStreet = isStreet;
    }

    @Override
    public boolean isMailing() {
        return this.isMailing;
    }

    @Override
    public void setMailing(boolean isMailing) {
        this.isMailing = isMailing;
    }

    @Override
    public String getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public void setVerificationLevel(String verificationLevel) {
        this.verificationLevel = verificationLevel;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        AddressImpl other = (AddressImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.addressLine1 == null ? other.addressLine1 != null : !this.addressLine1.equals(other.addressLine1)) {
            return false;
        }
        if (this.addressLine2 == null ? other.addressLine2 != null : !this.addressLine2.equals(other.addressLine2)) {
            return false;
        }
        if (this.city == null ? other.city != null : !this.city.equals(other.city)) {
            return false;
        }
        if (this.companyName == null ? other.companyName != null : !this.companyName.equals(other.companyName)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.isoCountryAlpha2 == null ? other.isoCountryAlpha2 != null : !this.isoCountryAlpha2.equals(other.isoCountryAlpha2)) {
            return false;
        }
        if (this.county == null ? other.county != null : !this.county.equals(other.county)) {
            return false;
        }
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.postalCode == null ? other.postalCode != null : !this.postalCode.equals(other.postalCode)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.isoCountrySubdivision == null ? other.isoCountrySubdivision != null : !this.isoCountrySubdivision.equals(other.isoCountrySubdivision)) {
            return false;
        }
        return !(this.stateProvinceRegion == null ? other.stateProvinceRegion != null : !this.stateProvinceRegion.equals(other.stateProvinceRegion));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressLine1 == null ? 0 : this.addressLine1.hashCode());
        result = 31 * result + (this.addressLine2 == null ? 0 : this.addressLine2.hashCode());
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.companyName == null ? 0 : this.companyName.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.isoCountryAlpha2 == null ? 0 : this.isoCountryAlpha2.hashCode());
        result = 31 * result + (this.county == null ? 0 : this.county.hashCode());
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.postalCode == null ? 0 : this.postalCode.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.isoCountrySubdivision == null ? 0 : this.isoCountrySubdivision.hashCode());
        result = 31 * result + (this.stateProvinceRegion == null ? 0 : this.stateProvinceRegion.hashCode());
        return result;
    }

    public <G extends Address> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        Address cloned = (Address)createResponse.getClone();
        cloned.setActive(this.isActive);
        cloned.setAddressLine1(this.addressLine1);
        cloned.setAddressLine2(this.addressLine2);
        cloned.setAddressLine3(this.addressLine3);
        cloned.setBusiness(this.isBusiness);
        cloned.setCity(this.city);
        cloned.setCompanyName(this.companyName);
        cloned.setCounty(this.county);
        cloned.setDefault(this.isDefault);
        cloned.setEmailAddress(this.emailAddress);
        cloned.setFirstName(this.firstName);
        cloned.setFullName(this.fullName);
        cloned.setIsoCountryAlpha2(this.isoCountryAlpha2);
        cloned.setIsoCountrySubdivision(this.isoCountrySubdivision);
        cloned.setStreet(this.isStreet);
        cloned.setZipFour(this.zipFour);
        cloned.setPhoneFax(this.phoneFax);
        cloned.setPhonePrimary(this.phonePrimary);
        cloned.setPostalCode(this.postalCode);
        cloned.setFax(this.fax);
        cloned.setMailing(this.isMailing);
        cloned.setStandardized(this.standardized);
        cloned.setTokenizedAddress(this.tokenizedAddress);
        cloned.setVerificationLevel(this.verificationLevel);
        cloned.setStateProvinceRegion(this.stateProvinceRegion);
        cloned.setPhoneSecondary(this.phoneSecondary);
        return createResponse;
    }
}

