/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.common.time.domain.TemporalTimestampListener;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER_ADDRESS")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="address.firstName", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address.lastName", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="address.addressLine1", mergeEntries={@AdminPresentationMergeEntry(propertyType="prominent", booleanOverrideValue=true)})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE)
@SQLDelete(sql="UPDATE BLC_CUSTOMER_ADDRESS SET ARCHIVED = 'Y' WHERE CUSTOMER_ADDRESS_ID = ?")
public class CustomerAddressImpl
implements CustomerAddress {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CustomerAddressId")
    @GenericGenerator(name="CustomerAddressId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CustomerAddressImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.profile.core.domain.CustomerAddressImpl")})
    @Column(name="CUSTOMER_ADDRESS_ID")
    protected Long id;
    @Column(name="ADDRESS_NAME")
    @AdminPresentation(friendlyName="CustomerAddressImpl_Address_Name", order=1, group="CustomerAddressImpl_Identification", groupOrder=1, prominent=true, gridOrder=1)
    protected String addressName;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @AdminPresentation(excluded=true, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Customer customer;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, targetEntity=AddressImpl.class, optional=false)
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="CUSTOMERADDRESS_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    protected Address address;
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getAddressName() {
        return this.addressName;
    }

    @Override
    public void setAddressName(String addressName) {
        this.addressName = addressName;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    public String toString() {
        return this.addressName == null ? this.address.getFirstName() + " - " + this.address.getAddressLine1() : this.addressName;
    }

    public Character getArchived() {
        ArchiveStatus temp = this.archiveStatus == null ? new ArchiveStatus() : this.archiveStatus;
        return temp.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public boolean isActive() {
        return 'Y' != this.getArchived().charValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.addressName == null ? 0 : this.addressName.hashCode());
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CustomerAddressImpl other = (CustomerAddressImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.addressName == null ? other.addressName != null : !this.addressName.equals(other.addressName)) {
            return false;
        }
        return !(this.customer == null ? other.customer != null : !this.customer.equals(other.customer));
    }

    public <G extends CustomerAddress> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        CustomerAddress cloned = (CustomerAddress)createResponse.getClone();
        cloned.setAddressName(this.addressName);
        cloned.setCustomer(this.customer);
        cloned.setArchived(this.getArchived());
        cloned.setAddress((Address)this.address.createOrRetrieveCopyInstance(context).getClone());
        return createResponse;
    }
}

