/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.common.security.RandomGenerator;
import org.broadleafcommerce.profile.web.core.security.SessionFixationProtectionCookie;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="blSessionFixationProtectionFilter")
public class SessionFixationProtectionFilter
extends GenericFilterBean {
    protected static final String SESSION_ATTR = "SFP-ActiveID";
    @Resource(name="blEncryptionModule")
    protected EncryptionModule encryptionModule;

    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain chain) throws IOException, ServletException {
        String activeIdSessionValue;
        HttpServletRequest request = (HttpServletRequest)sRequest;
        HttpServletResponse response = (HttpServletResponse)sResponse;
        HttpSession session = request.getSession(false);
        if (SecurityContextHolder.getContext() == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        if (StringUtils.isNotBlank((String)(activeIdSessionValue = (String)session.getAttribute(SESSION_ATTR))) && request.isSecure()) {
            String activeIdCookieValue = SessionFixationProtectionCookie.readActiveID(request);
            String decryptedActiveIdValue = this.encryptionModule.decrypt(activeIdCookieValue);
            if (!activeIdSessionValue.equals(decryptedActiveIdValue)) {
                this.abortUser(request, response);
            }
        } else if (request.isSecure()) {
            String token;
            try {
                token = RandomGenerator.generateRandomId((String)"SHA1PRNG", (int)32);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
            String encryptedActiveIdValue = this.encryptionModule.encrypt(token);
            session.setAttribute(SESSION_ATTR, (Object)token);
            SessionFixationProtectionCookie.writeActiveID(request, response, encryptedActiveIdValue);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void abortUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SecurityContextHolder.clearContext();
        SessionFixationProtectionCookie.remove(request, response);
        Cookie cookie = new Cookie("JSESSIONID", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setSecure(false);
        cookie.setValue("-1");
        response.addCookie(cookie);
        response.sendRedirect("/");
    }
}

