/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionFixationProtectionCookie {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String COOKIE_NAME = "ActiveID";

    public static String readActiveID(HttpServletRequest request) {
        String cookieData;
        block3: {
            cookieData = null;
            try {
                Cookie[] cookies = request.getCookies();
                if (cookies == null) break block3;
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(COOKIE_NAME)) continue;
                    cookieData = cookie.getValue();
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cookieData;
    }

    public static void writeActiveID(HttpServletRequest request, HttpServletResponse response, String data) {
        if (data != null) {
            Cookie cookie = new Cookie(COOKIE_NAME, data);
            cookie.setMaxAge(-1);
            cookie.setSecure(true);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }

    public static void remove(HttpServletRequest request, HttpServletResponse response) {
        if (request != null && request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(COOKIE_NAME)) continue;
                cookie.setMaxAge(0);
                cookie.setPath("/");
                cookie.setSecure(true);
                cookie.setValue("-1");
                response.addCookie(cookie);
            }
        }
    }

    public static void forceRemove(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(COOKIE_NAME, "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setSecure(true);
        cookie.setValue("-1");
        response.addCookie(cookie);
    }
}

