/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.security.CustomerAuthenticatedFromCookieEvent;
import org.broadleafcommerce.profile.web.core.security.CustomerLoggedInEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="blCustomerStateFilter")
public class CustomerStateFilter
extends GenericFilterBean
implements ApplicationEventPublisherAware,
Ordered {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    private ApplicationEventPublisher eventPublisher;
    private static String customerRequestAttributeName = "customer";
    public static final String ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME = "_blc_anonymousCustomer";
    private static final String LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME = "_blc_lastPublishedEvent";

    public void doFilter(ServletRequest baseRequest, ServletResponse baseResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)baseRequest;
        HttpServletResponse response = (HttpServletResponse)baseResponse;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Customer customer = null;
        if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
            String userName = request.getUserPrincipal().getName();
            customer = (Customer)request.getAttribute(customerRequestAttributeName);
            if (!(userName == null || customer != null && userName.equals(customer.getUsername()))) {
                customer = this.customerService.readCustomerByUsername(userName);
                if (this.logger.isDebugEnabled() && customer != null) {
                    this.logger.debug((Object)("Customer found by username " + userName));
                }
            }
            if (customer != null) {
                ApplicationEvent lastPublishedEvent = (ApplicationEvent)request.getSession(true).getAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME);
                if (authentication instanceof RememberMeAuthenticationToken) {
                    CustomerAuthenticatedFromCookieEvent cookieEvent;
                    customer.setCookied(true);
                    boolean publishRememberMeEvent = true;
                    if (lastPublishedEvent != null && lastPublishedEvent instanceof CustomerAuthenticatedFromCookieEvent && userName.equals((cookieEvent = (CustomerAuthenticatedFromCookieEvent)lastPublishedEvent).getCustomer().getUsername())) {
                        publishRememberMeEvent = false;
                    }
                    if (publishRememberMeEvent) {
                        cookieEvent = new CustomerAuthenticatedFromCookieEvent(customer, ((Object)((Object)this)).getClass().getName());
                        this.eventPublisher.publishEvent((ApplicationEvent)cookieEvent);
                        request.getSession().setAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, (Object)cookieEvent);
                    }
                } else if (authentication instanceof UsernamePasswordAuthenticationToken) {
                    CustomerLoggedInEvent loggedInEvent;
                    customer.setLoggedIn(true);
                    boolean publishLoggedInEvent = true;
                    if (lastPublishedEvent != null && lastPublishedEvent instanceof CustomerLoggedInEvent && userName.equals((loggedInEvent = (CustomerLoggedInEvent)lastPublishedEvent).getCustomer().getUsername())) {
                        publishLoggedInEvent = false;
                    }
                    if (publishLoggedInEvent) {
                        loggedInEvent = new CustomerLoggedInEvent(customer, ((Object)((Object)this)).getClass().getName());
                        this.eventPublisher.publishEvent((ApplicationEvent)loggedInEvent);
                        request.getSession().setAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, (Object)loggedInEvent);
                    }
                } else {
                    customer = null;
                }
            }
        }
        if (customer == null && (customer = (Customer)request.getSession(true).getAttribute(ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME)) == null) {
            customer = this.customerService.createNewCustomer();
            customer.setAnonymous(true);
            request.getSession().setAttribute(ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME, (Object)customer);
        }
        request.setAttribute(customerRequestAttributeName, customer);
        HashMap<String, Customer> ruleMap = (HashMap<String, Customer>)request.getAttribute(BLC_RULE_MAP_PARAM);
        if (ruleMap == null) {
            ruleMap = new HashMap<String, Customer>();
        }
        ruleMap.put("customer", customer);
        request.setAttribute(BLC_RULE_MAP_PARAM, ruleMap);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public int getOrder() {
        return 1501;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public static String getCustomerRequestAttributeName() {
        return customerRequestAttributeName;
    }

    public static void setCustomerRequestAttributeName(String customerRequestAttributeName) {
        CustomerStateFilter.customerRequestAttributeName = customerRequestAttributeName;
    }
}

