/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.profile.util.StringUtil;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class BroadleafAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private String defaultFailureUrl;

    public BroadleafAuthenticationFailureHandler() {
    }

    public BroadleafAuthenticationFailureHandler(String defaultFailureUrl) {
        super(defaultFailureUrl);
        this.defaultFailureUrl = defaultFailureUrl;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String failureUrlParam = StringUtil.cleanseUrlString((String)request.getParameter("failureUrl"));
        String successUrlParam = StringUtil.cleanseUrlString((String)request.getParameter("successUrl"));
        String failureUrl = StringUtils.trimToNull((String)failureUrlParam);
        if (failureUrl == null) {
            failureUrl = StringUtils.trimToNull((String)this.defaultFailureUrl);
        }
        if (failureUrl != null) {
            if (StringUtils.isNotEmpty((String)successUrlParam)) {
                failureUrl = !failureUrl.contains("?") ? failureUrl + "?successUrl=" + successUrlParam : failureUrl + "&successUrl=" + successUrlParam;
            }
            this.getRedirectStrategy().sendRedirect(request, response, failureUrl);
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }
}

