/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service;

import com.paypal.api.payments.WebProfile;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.PayPalWebProfileService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateWebProfileRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateWebProfileResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="blPayPalWebProfileService")
public class PayPalWebProfileServiceImpl
implements PayPalWebProfileService {
    private static final Log LOG = LogFactory.getLog(PayPalWebProfileServiceImpl.class);
    protected WebProfile webProfile;
    protected String beanProfileId;
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;

    @Autowired(required=false)
    public PayPalWebProfileServiceImpl(WebProfile webProfile) {
        this.webProfile = webProfile;
        if (webProfile != null && StringUtils.isBlank((CharSequence)webProfile.getId()) && LOG.isWarnEnabled()) {
            LOG.warn((Object)"The WebProfile provided did not specify an id. Beware that this will result in creating new WebProfiles linked to your PayPal account on every server startup.To avoid this either set an id on the provided WebProfile bean or set the property gateway.paypal.checkout.rest.webProfileId.To obtain a WebProfile id either create a WebProfile or select an existing an id from you PayPal account following the instructions here https://developer.paypal.com/docs/api/payment-experience/v1/#web-profiles");
        }
    }

    public PayPalWebProfileServiceImpl() {
    }

    @Override
    public String getWebProfileId(PaymentRequestDTO paymentRequestDTO) {
        String profileId = this.getPropertyWebProfileId();
        if (StringUtils.isNotBlank((CharSequence)profileId)) {
            return profileId;
        }
        return this.getBeanWebProfileId(paymentRequestDTO);
    }

    protected String getBeanWebProfileId(PaymentRequestDTO paymentRequestDTO) {
        if (StringUtils.isNotBlank((CharSequence)this.beanProfileId)) {
            return this.beanProfileId;
        }
        if (this.webProfile == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.webProfile.getId())) {
            return this.webProfile.getId();
        }
        WebProfile profile = this.createWebProfile(this.webProfile, paymentRequestDTO);
        if (profile != null) {
            this.beanProfileId = profile.getId();
        }
        return this.beanProfileId;
    }

    protected WebProfile createWebProfile(WebProfile profile, PaymentRequestDTO paymentRequestDTO) {
        try {
            PayPalCreateWebProfileResponse response = (PayPalCreateWebProfileResponse)this.externalCallService.call(new PayPalCreateWebProfileRequest(profile, this.externalCallService.constructAPIContext(paymentRequestDTO)));
            return response.getWebProfile();
        }
        catch (PaymentException e) {
            LOG.error((Object)"Error retrieving WebProfile from PayPal", (Throwable)e);
            return null;
        }
    }

    protected String getPropertyWebProfileId() {
        return this.externalCallService.getConfiguration().getWebProfileId();
    }
}

