/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service;

import com.paypal.api.payments.MerchantPreferences;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.Plan;
import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.service.CurrentOrderPaymentRequestService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.ExternalCallPayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.api.AgreementToken;
import org.broadleafcommerce.vendor.paypal.service.PayPalAgreementTokenService;
import org.broadleafcommerce.vendor.paypal.service.PayPalWebProfileService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateAgreementTokenRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCreateAgreementTokenResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="blPayPalAgreementTokenService")
public class PayPalAgreementTokenServiceImpl
implements PayPalAgreementTokenService {
    @Resource(name="blExternalCallPayPalCheckoutService")
    protected ExternalCallPayPalCheckoutService externalCallService;
    @Resource(name="blPayPalWebProfileService")
    protected PayPalWebProfileService webProfileService;
    @Autowired(required=false)
    protected CurrentOrderPaymentRequestService currentOrderPaymentRequestService;

    @Override
    public AgreementToken createPayPalAgreementTokenForCurrentOrder(boolean performCheckoutOnReturn) throws PaymentException {
        PaymentRequestDTO paymentRequestDTO = this.getPaymentRequestForCurrentOrder();
        String agreementDescription = this.constructAgreementDescription(paymentRequestDTO);
        Payer payer = this.constructPayer(paymentRequestDTO);
        Plan plan = this.constructPlan(paymentRequestDTO, performCheckoutOnReturn);
        AgreementToken agreementToken = new AgreementToken(agreementDescription, payer, plan);
        return this.createAgreementToken(agreementToken, paymentRequestDTO);
    }

    protected Plan constructPlan(PaymentRequestDTO paymentRequestDTO, boolean performCheckoutOnReturn) {
        Plan plan = new Plan();
        plan.setType("MERCHANT_INITIATED_BILLING");
        MerchantPreferences merchantPreferences = new MerchantPreferences();
        merchantPreferences.setCancelUrl(this.externalCallService.getConfiguration().getCancelUrl());
        String returnUrl = this.externalCallService.getConfiguration().getReturnUrl();
        if (performCheckoutOnReturn) {
            returnUrl = returnUrl + "?CheckoutComplete=true";
        }
        merchantPreferences.setReturnUrl(returnUrl);
        merchantPreferences.setAcceptedPaymentType("INSTANT");
        plan.setMerchantPreferences(merchantPreferences);
        return plan;
    }

    protected Payer constructPayer(PaymentRequestDTO paymentRequestDTO) {
        Payer payer = new Payer();
        payer.setPaymentMethod("paypal");
        return payer;
    }

    protected AgreementToken createAgreementToken(AgreementToken agreementToken, PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalCreateAgreementTokenResponse response = (PayPalCreateAgreementTokenResponse)this.externalCallService.call(new PayPalCreateAgreementTokenRequest(agreementToken, this.externalCallService.constructAPIContext(paymentRequestDTO)));
        return response.getAgreementToken();
    }

    protected String constructAgreementDescription(PaymentRequestDTO paymentRequestDTO) {
        return this.externalCallService.getConfiguration().getPaymentDescription();
    }

    @Override
    public PaymentRequestDTO getPaymentRequestForCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.getPaymentRequestFromCurrentOrder();
        }
        throw new PaymentException("Unable to get PaymentRequestDTO for current order");
    }

    @Override
    public String getPayPalBillingAgreementIdFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("BILLING_AGREEMENT_ID");
        }
        throw new PaymentException("Unable to retrieve PayPal Billing Agreement ID for current order");
    }

    @Override
    public void setPayPalBillingAgreementIdOnCurrentOrder(String billingAgreementId) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal Billing Agreement ID on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("BILLING_AGREEMENT_ID", billingAgreementId);
    }

    @Override
    public String getPayPalAgreementTokenFromCurrentOrder() throws PaymentException {
        if (this.currentOrderPaymentRequestService != null) {
            return this.currentOrderPaymentRequestService.retrieveOrderAttributeFromCurrentOrder("AGREEMENT_TOKEN_ID");
        }
        throw new PaymentException("Unable to retrieve PayPal Agreement Token for current order");
    }

    @Override
    public void setPayPalAgreementTokenOnCurrentOrder(String agreementToken) throws PaymentException {
        if (this.currentOrderPaymentRequestService == null) {
            throw new PaymentException("Unable to set PayPal Agreement token on current order");
        }
        this.currentOrderPaymentRequestService.addOrderAttributeToCurrentOrder("AGREEMENT_TOKEN_ID", agreementToken);
    }
}

