/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.common.config.service.SystemPropertiesService;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.service.AbstractPaymentGatewayConfiguration;
import org.broadleafcommerce.common.web.BaseUrlResolver;
import org.broadleafcommerce.payment.service.gateway.PayPalCheckoutConfiguration;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalShippingDisplayType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="blPayPalCheckoutConfiguration")
public class PayPalCheckoutConfigurationImpl
extends AbstractPaymentGatewayConfiguration
implements PayPalCheckoutConfiguration {
    @Resource(name="blBaseUrlResolver")
    protected BaseUrlResolver urlResolver;
    @Autowired
    protected SystemPropertiesService propertiesService;
    protected int failureReportingThreshold = 1;
    protected boolean performAuthorizeAndCapture = true;

    @Override
    public String getReturnUrl() {
        String url = this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.returnUrl");
        try {
            URI u = new URI(url);
            if (u.isAbsolute()) {
                return url;
            }
            String baseUrl = this.urlResolver.getSiteBaseUrl();
            return baseUrl + url;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value for 'gateway.paypal.checkout.rest.returnUrl' is not valid.", e);
        }
    }

    @Override
    public String getCancelUrl() {
        String url = this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.cancelUrl");
        try {
            URI u = new URI(url);
            if (u.isAbsolute()) {
                return url;
            }
            String baseUrl = this.urlResolver.getSiteBaseUrl();
            return baseUrl + url;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The value for 'gateway.paypal.checkout.rest.cancelUrl' is not valid.", e);
        }
    }

    @Override
    public String getWebProfileId() {
        return this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.webProfileId");
    }

    @Override
    public String getPaymentDescription() {
        return this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.description");
    }

    @Override
    public String getSmartPaymentEnvironment() {
        return this.propertiesService.resolveSystemProperty("gateway.paypal.smart.button.env");
    }

    @Override
    public PayPalShippingDisplayType getShippingDisplayType() {
        String shippingType = this.propertiesService.resolveSystemProperty("gateway.paypal.expressCheckout.shippingDisplayType");
        PayPalShippingDisplayType displayType = PayPalShippingDisplayType.getInstance(shippingType);
        if (displayType != null) {
            return displayType;
        }
        return PayPalShippingDisplayType.NO_DISPLAY;
    }

    @Override
    public String getTotalType() {
        return "Total";
    }

    @Override
    public Map<String, String> getAdditionalConfig() {
        HashMap<String, String> additionalConfigs = new HashMap<String, String>();
        additionalConfigs.put("HDRBORDERCOLOR", "FFFFFF");
        additionalConfigs.put("HDRBACKCOLOR", "FFFFFF");
        additionalConfigs.put("PAYFLOWCOLOR", "FFFFFF");
        return additionalConfigs;
    }

    @Override
    public Map<String, String> getAdditionalCustomFields() {
        return new HashMap<String, String>();
    }

    @Override
    public String getCheckoutRestClientId() {
        return this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.clientId");
    }

    @Override
    public String getCheckoutRestSecret() {
        return this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.secret");
    }

    @Override
    public String getCheckoutRestMode() {
        return this.propertiesService.resolveSystemProperty("gateway.paypal.checkout.rest.mode");
    }

    public boolean handlesAuthorize() {
        return true;
    }

    public boolean handlesCapture() {
        return true;
    }

    public boolean handlesAuthorizeAndCapture() {
        return true;
    }

    public boolean handlesReverseAuthorize() {
        return true;
    }

    public boolean handlesVoid() {
        return true;
    }

    public boolean handlesRefund() {
        return true;
    }

    public boolean handlesPartialCapture() {
        return false;
    }

    public boolean handlesMultipleShipment() {
        return false;
    }

    public boolean handlesRecurringPayment() {
        return false;
    }

    public boolean handlesSavedCustomerPayment() {
        return false;
    }

    public boolean isPerformAuthorizeAndCapture() {
        return this.performAuthorizeAndCapture;
    }

    public void setPerformAuthorizeAndCapture(boolean performAuthorizeAndCapture) {
        this.performAuthorizeAndCapture = performAuthorizeAndCapture;
    }

    public int getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public void setFailureReportingThreshold(int failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public boolean handlesMultiplePayments() {
        return false;
    }

    public PaymentGatewayType getGatewayType() {
        return PayPalCheckoutPaymentGatewayType.PAYPAL_CHECKOUT;
    }
}

