/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import com.paypal.api.payments.Capture;
import com.paypal.api.payments.RefundRequest;
import com.paypal.api.payments.Sale;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRefundResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponse;

public class PayPalRefundRequest
extends PayPalRequest {
    protected RefundRequest refundRequest;
    protected Capture capture;
    protected Sale sale;

    public PayPalRefundRequest(RefundRequest refundRequest, Capture capture, APIContext apiContext) {
        super(apiContext);
        this.refundRequest = refundRequest;
        this.capture = capture;
    }

    public PayPalRefundRequest(RefundRequest refundRequest, Sale sale, APIContext apiContext) {
        super(apiContext);
        this.refundRequest = refundRequest;
        this.sale = sale;
    }

    @Override
    protected PayPalResponse executeInternal() throws PayPalRESTException {
        if (this.capture != null) {
            return new PayPalRefundResponse(this.capture.refund(this.apiContext, this.refundRequest));
        }
        return new PayPalRefundResponse(this.sale.refund(this.apiContext, this.refundRequest));
    }

    @Override
    protected boolean isRequestValid() {
        return this.refundRequest != null && this.refundRequest.getAmount() != null && (this.capture != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.capture.getId()}) || this.sale != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.sale.getId()}));
    }
}

