/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayHostedService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

@Component(value="blPayPalExpressCheckoutLinkProcessor")
public class PayPalExpressCheckoutLinkProcessor
extends AbstractAttributeModifierAttrProcessor {
    @Resource(name="blPayPalExpressHostedService")
    private PaymentGatewayHostedService paymentGatewayHostedService;

    public PayPalExpressCheckoutLinkProcessor() {
        super("paypal_express_link");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        PaymentRequestDTO requestDTO = (PaymentRequestDTO)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
        String url = "";
        if (requestDTO != null) {
            if (element.getAttributeValue("complete_checkout") != null) {
                Boolean completeCheckout = (Boolean)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue("complete_checkout"));
                element.removeAttribute("complete_checkout");
                requestDTO.completeCheckoutOnCallback(completeCheckout.booleanValue());
            }
            try {
                PaymentResponseDTO responseDTO = this.paymentGatewayHostedService.requestHostedEndpoint(requestDTO);
                url = ((String)responseDTO.getResponseMap().get("REDIRECTURL")).toString();
                if (requestDTO.isCompleteCheckoutOnCallback()) {
                    url = url + "&useraction=commit";
                }
            }
            catch (PaymentException e) {
                throw new RuntimeException("Unable to Create the PayPal Express Link", e);
            }
        }
        attrs.put("href", url);
        return attrs;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

