/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.web.controller;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfiguration;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.common.web.payment.controller.PaymentGatewayAbstractController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="blPayPalExpressController")
@RequestMapping(value={"/paypal-express"})
public class BroadleafPayPalExpressController
extends PaymentGatewayAbstractController {
    protected static final Log LOG = LogFactory.getLog(BroadleafPayPalExpressController.class);
    protected static final String GATEWAY_CONTEXT_KEY = "paypal-express";
    @Resource(name="blPayPalExpressWebResponseService")
    protected PaymentGatewayWebResponseService paymentGatewayWebResponseService;
    @Resource(name="blPayPalExpressConfiguration")
    protected PaymentGatewayConfiguration paymentGatewayConfiguration;

    public void handleProcessingException(Exception e, RedirectAttributes redirectAttributes) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"A Processing Exception Occurred for paypal-express. Adding Error to Redirect Attributes.");
        }
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)BroadleafPayPalExpressController.getProcessingErrorMessage());
    }

    public void handleUnsuccessfulTransaction(Model model, RedirectAttributes redirectAttributes, PaymentResponseDTO responseDTO) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"The Transaction was unsuccessful for paypal-express. Adding Error to Redirect Attributes.");
        }
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)BroadleafPayPalExpressController.getProcessingErrorMessage());
    }

    public String getGatewayContextKey() {
        return GATEWAY_CONTEXT_KEY;
    }

    public PaymentGatewayWebResponseService getWebResponseService() {
        return this.paymentGatewayWebResponseService;
    }

    public PaymentGatewayConfiguration getConfiguration() {
        return this.paymentGatewayConfiguration;
    }

    @RequestMapping(value={"/return"}, method={RequestMethod.GET})
    public String returnEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        return super.process(model, request, redirectAttributes);
    }

    @RequestMapping(value={"/error"}, method={RequestMethod.GET})
    public String errorEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        redirectAttributes.addAttribute("PAYMENT_PROCESSING_ERROR", (Object)request.getParameter("PAYMENT_PROCESSING_ERROR"));
        return this.getCartViewRedirect();
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.GET})
    public String cancelEndpoint(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes, @PathVariable Map<String, String> pathVars) throws PaymentException {
        return this.getOrderReviewRedirect();
    }
}

