/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.util.BLCRequestUtils;
import org.broadleafcommerce.payment.service.gateway.PayPalExpressConfiguration;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequestGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalItemRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalShippingRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalShippingDisplayType;
import org.springframework.stereotype.Service;

@Service(value="blPayPalExpressRequestGenerator")
public class PayPalRequestGeneratorImpl
implements PayPalRequestGenerator {
    @Resource(name="blPayPalExpressConfiguration")
    protected PayPalExpressConfiguration configuration;
    protected Logger logger = Logger.getLogger(PayPalRequestGeneratorImpl.class);

    @Override
    public List<NameValuePair> buildRequest(PayPalRequest request) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        this.setBaseNvps(nvps);
        if (PayPalMethodType.CHECKOUT.equals(request.getMethodType())) {
            this.setNvpsForCheckoutOrAuth(nvps, (PayPalPaymentRequest)request, "Sale");
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}), ((PayPalPaymentRequest)request).getCurrency()));
        } else if (PayPalMethodType.AUTHORIZATION.equals(request.getMethodType())) {
            this.setNvpsForCheckoutOrAuth(nvps, (PayPalPaymentRequest)request, "Authorization");
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}), ((PayPalPaymentRequest)request).getCurrency()));
        } else if (PayPalMethodType.PROCESS.equals(request.getMethodType())) {
            this.setNvpsForProcess(nvps, (PayPalPaymentRequest)request);
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CURRENCYCODE", new Integer[]{0}, new String[]{"n"}), ((PayPalPaymentRequest)request).getCurrency()));
        } else if (PayPalMethodType.REFUND.equals(request.getMethodType())) {
            this.setNvpsForRefund(nvps, (PayPalPaymentRequest)request);
            nvps.add(new NameValuePair("CURRENCYCODE", ((PayPalPaymentRequest)request).getCurrency()));
        } else if (PayPalMethodType.CAPTURE.equals(request.getMethodType())) {
            this.setNvpsForCapture(nvps, (PayPalPaymentRequest)request);
            nvps.add(new NameValuePair("CURRENCYCODE", ((PayPalPaymentRequest)request).getCurrency()));
        } else if (PayPalMethodType.VOID.equals(request.getMethodType())) {
            this.setNvpsForVoid(nvps, (PayPalPaymentRequest)request);
        } else if (PayPalMethodType.DETAILS.equals(request.getMethodType())) {
            this.setNvpsForDetails(nvps, (PayPalDetailsRequest)request);
        } else {
            throw new IllegalArgumentException("Method type not supported: " + request.getMethodType().getFriendlyType());
        }
        return nvps;
    }

    protected void setNvpsForDetails(List<NameValuePair> nvps, PayPalDetailsRequest paymentRequest) {
        nvps.add(new NameValuePair("TOKEN", paymentRequest.getToken()));
        nvps.add(new NameValuePair("METHOD", "GetExpressCheckoutDetails"));
    }

    protected void setNvpsForVoid(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        nvps.add(new NameValuePair("AUTHORIZATIONID", paymentRequest.getTransactionID()));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair("METHOD", "DoVoid"));
    }

    protected void setNvpsForCapture(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        nvps.add(new NameValuePair("AUTHORIZATIONID", paymentRequest.getTransactionID()));
        nvps.add(new NameValuePair("AMT", paymentRequest.getSummaryRequest().getGrandTotal().toString()));
        nvps.add(new NameValuePair("COMPLETETYPE", "Complete"));
        if (this.getAdditionalConfig() != null) {
            for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
                nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        nvps.add(new NameValuePair("METHOD", "DoCapture"));
    }

    protected void setNvpsForRefund(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        nvps.add(new NameValuePair("TRANSACTIONID", paymentRequest.getTransactionID()));
        nvps.add(new NameValuePair("REFUNDTYPE", paymentRequest.getRefundType().getType()));
        if (paymentRequest.getRefundType() != PayPalRefundType.FULL) {
            nvps.add(new NameValuePair("AMT", paymentRequest.getSummaryRequest().getGrandTotal().toString()));
        }
        nvps.add(new NameValuePair("METHOD", "RefundTransaction"));
    }

    protected void setNvpsForProcess(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        if (paymentRequest.getSecondaryMethodType() != null && PayPalMethodType.AUTHORIZATION.equals(paymentRequest.getSecondaryMethodType())) {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTACTION", new Integer[]{0}, new String[]{"n"}), "Authorization"));
        } else {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTACTION", new Integer[]{0}, new String[]{"n"}), "Sale"));
        }
        nvps.add(new NameValuePair("TOKEN", paymentRequest.getToken()));
        nvps.add(new NameValuePair("PAYERID", paymentRequest.getPayerID()));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_AMT", new Integer[]{0}, new String[]{"n"}), paymentRequest.getSummaryRequest().getGrandTotal().toString()));
        nvps.add(new NameValuePair("METHOD", "DoExpressCheckoutPayment"));
        nvps.add(new NameValuePair("BUTTONSOURCE", "BroadleafCommerce_Cart_EC"));
    }

    protected void setBaseNvps(List<NameValuePair> nvps) {
        nvps.add(new NameValuePair("USER", this.getUser()));
        nvps.add(new NameValuePair("PWD", this.getPassword()));
        nvps.add(new NameValuePair("SIGNATURE", this.getSignature()));
        nvps.add(new NameValuePair("VERSION", this.getLibVersion()));
    }

    protected void setNvpsForCheckoutOrAuth(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest, String payPalAction) {
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_PAYMENTACTION", new Integer[]{0}, new String[]{"n"}), payPalAction));
        String customField = Boolean.toString(paymentRequest.isCompleteCheckoutOnCallback()) + "_" + paymentRequest.getOrderId();
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_CUSTOM", new Integer[]{0}, new String[]{"n"}), customField));
        nvps.add(new NameValuePair("NOSHIPPING", this.getShippingDisplayType().getType()));
        if (PayPalShippingDisplayType.PROVIDE_SHIPPING.equals(this.getShippingDisplayType())) {
            nvps.add(new NameValuePair("ADDROVERRIDE", "1"));
            this.setShippingNvps(nvps, paymentRequest);
        }
        this.setCostNvps(nvps, paymentRequest);
        nvps.add(new NameValuePair("RETURNURL", this.getReturnUrl()));
        nvps.add(new NameValuePair("CANCELURL", this.getCancelUrl()));
        nvps.add(new NameValuePair("TOTALTYPE", this.getTotalType()));
        for (Map.Entry<String, String> entry : this.getAdditionalConfig().entrySet()) {
            nvps.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        nvps.add(new NameValuePair("METHOD", "SetExpressCheckout"));
    }

    protected void setCostNvps(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        int counter = 0;
        for (PayPalItemRequest itemRequest : paymentRequest.getItemRequests()) {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_NAMEm", new Integer[]{0, counter}, new String[]{"n", "m"}), StringUtils.abbreviate((String)itemRequest.getShortDescription(), (int)120)));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_NUMBERm", new Integer[]{0, counter}, new String[]{"n", "m"}), itemRequest.getSystemId()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_DESCm", new Integer[]{0, counter}, new String[]{"n", "m"}), StringUtils.abbreviate((String)itemRequest.getDescription(), (int)120)));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_AMTm", new Integer[]{0, counter}, new String[]{"n", "m"}), this.handleZeroConversionForMoney(itemRequest.getUnitPrice())));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("L_PAYMENTREQUEST_n_QTYm", new Integer[]{0, counter}, new String[]{"n", "m"}), String.valueOf(itemRequest.getQuantity())));
            ++counter;
        }
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_ITEMAMT", new Integer[]{0}, new String[]{"n"}), this.handleZeroConversionForMoney(paymentRequest.getSummaryRequest().getSubTotal())));
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_TAXAMT", new Integer[]{0}, new String[]{"n"}), this.handleZeroConversionForMoney(paymentRequest.getSummaryRequest().getTotalTax())));
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPPINGAMT", new Integer[]{0}, new String[]{"n"}), this.handleZeroConversionForMoney(paymentRequest.getSummaryRequest().getTotalShipping())));
        nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_AMT", new Integer[]{0}, new String[]{"n"}), this.handleZeroConversionForMoney(paymentRequest.getSummaryRequest().getGrandTotal())));
    }

    protected void setShippingNvps(List<NameValuePair> nvps, PayPalPaymentRequest paymentRequest) {
        int counter = 0;
        for (PayPalShippingRequest shippingRequest : paymentRequest.getShippingRequests()) {
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTONAME", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToName()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOSTREET", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToStreet()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOSTREET2", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToStreet2()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOCITY", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToCity()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOSTATE", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToState()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOZIP", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToZip()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOCOUNTRYCODE", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToCountryCode()));
            nvps.add(new NameValuePair(this.replaceNumericBoundProperty("PAYMENTREQUEST_n_SHIPTOPHONENUM", new Integer[]{counter}, new String[]{"n"}), shippingRequest.getShipToPhoneNum()));
            ++counter;
        }
    }

    protected String handleZeroConversionForMoney(Money money) {
        if (money.isZero()) {
            return "0";
        }
        return money.toString();
    }

    protected String replaceNumericBoundProperty(String property, Integer[] number, String[] positions) {
        int counter = 0;
        for (String position : positions) {
            int pos = property.indexOf(position);
            if (pos < 0) {
                throw new IllegalArgumentException("Property does not contain the specified position value (" + position + ")");
            }
            String newValue = String.valueOf(number[counter]);
            property = property.substring(0, pos) + newValue + property.substring(pos + position.length(), property.length());
            ++counter;
        }
        return property;
    }

    @Override
    public Map<String, String> getAdditionalConfig() {
        return this.configuration.getAdditionalConfig();
    }

    @Override
    public String getCancelUrl() {
        return Boolean.TRUE.equals(this.getUseRelativeUrls()) ? BLCRequestUtils.getRequestedServerPrefix() + this.configuration.getCancelUrl() : this.configuration.getCancelUrl();
    }

    @Override
    public String getLibVersion() {
        return this.configuration.getLibVersion();
    }

    @Override
    public String getPassword() {
        return this.configuration.getPassword();
    }

    @Override
    public String getReturnUrl() {
        return Boolean.TRUE.equals(this.getUseRelativeUrls()) ? BLCRequestUtils.getRequestedServerPrefix() + this.configuration.getReturnUrl() : this.configuration.getReturnUrl();
    }

    @Override
    public String getSignature() {
        return this.configuration.getSignature();
    }

    @Override
    public String getUser() {
        return this.configuration.getUser();
    }

    @Override
    public String getTotalType() {
        return this.configuration.getTotalType();
    }

    @Override
    public Boolean getUseRelativeUrls() {
        return this.configuration.getUseRelativeUrls();
    }

    @Override
    public PayPalShippingDisplayType getShippingDisplayType() {
        return this.configuration.getShippingDisplayType();
    }
}

