/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayReportingService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponsePrintService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.springframework.stereotype.Service;

@Service(value="blPayPalExpressWebResponseService")
public class PayPalExpressWebResponseServiceImpl
implements PaymentGatewayWebResponseService {
    @Resource(name="blPaymentGatewayWebResponsePrintService")
    protected PaymentGatewayWebResponsePrintService webResponsePrintService;
    @Resource(name="blPayPalExpressReportingService")
    protected PaymentGatewayReportingService reportingService;

    public PaymentResponseDTO translateWebResponse(HttpServletRequest request) throws PaymentException {
        PaymentRequestDTO requestDTO = new PaymentRequestDTO().additionalField("TOKEN", (Object)request.getParameter("token"));
        PaymentResponseDTO responseDTO = this.reportingService.findDetailsByTransaction(requestDTO);
        responseDTO.responseMap("HTTP_REQUEST", this.webResponsePrintService.printRequest(request)).paymentTransactionType(PaymentTransactionType.UNCONFIRMED);
        return responseDTO;
    }
}

