/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.AbstractPayPalExpressService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalExpressPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalTransactionType;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blPayPalExpressTransactionService")
public class PayPalExpressTransactionServiceImpl
extends AbstractPayPalExpressService
implements PaymentGatewayTransactionService {
    public String getServiceName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public PaymentResponseDTO authorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("PAYERID"), (String)"The RequestDTO must contain a PAYERID");
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TOKEN"), (String)"The RequestDTO must contain a TOKEN");
        return this.commonAuthorizeOrSale(paymentRequestDTO, PayPalTransactionType.AUTHORIZE, (String)paymentRequestDTO.getAdditionalFields().get("TOKEN"), (String)paymentRequestDTO.getAdditionalFields().get("PAYERID"));
    }

    public PaymentResponseDTO capture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TRANSACTIONID"), (String)"The RequestDTO must contain a TRANSACTIONID");
        PayPalPaymentRequest request = this.buildBasicRequest(paymentRequestDTO, PayPalTransactionType.CAPTURE);
        request.setMethodType(PayPalMethodType.CAPTURE);
        request.setTransactionID((String)paymentRequestDTO.getAdditionalFields().get("TRANSACTIONID"));
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS);
        PayPalPaymentResponse response = (PayPalPaymentResponse)this.process(request);
        this.setCommonPaymentResponse(response, responseDTO);
        responseDTO.successful(response.isSuccessful());
        responseDTO.paymentTransactionType(PaymentTransactionType.CAPTURE);
        this.setDecisionInformation(response, responseDTO);
        return responseDTO;
    }

    public PaymentResponseDTO authorizeAndCapture(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("PAYERID"), (String)"The RequestDTO must contain a PAYERID");
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TOKEN"), (String)"The RequestDTO must contain a TOKEN");
        return this.commonAuthorizeOrSale(paymentRequestDTO, PayPalTransactionType.AUTHORIZEANDCAPTURE, (String)paymentRequestDTO.getAdditionalFields().get("TOKEN"), (String)paymentRequestDTO.getAdditionalFields().get("PAYERID"));
    }

    public PaymentResponseDTO reverseAuthorize(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TRANSACTIONID"), (String)"The RequestDTO must contain a TRANSACTIONID");
        PayPalPaymentRequest request = this.buildBasicRequest(paymentRequestDTO, PayPalTransactionType.REVERSEAUTHORIZE);
        request.setMethodType(PayPalMethodType.VOID);
        request.setTransactionID((String)paymentRequestDTO.getAdditionalFields().get("TRANSACTIONID"));
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS);
        PayPalPaymentResponse response = (PayPalPaymentResponse)this.process(request);
        this.setCommonPaymentResponse(response, responseDTO);
        responseDTO.successful(response.isSuccessful());
        responseDTO.paymentTransactionType(PaymentTransactionType.REVERSE_AUTH);
        this.setDecisionInformation(response, responseDTO);
        return responseDTO;
    }

    public PaymentResponseDTO refund(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("REFUNDTYPE"), (String)"The RequestDTO must contain a REFUNDTYPE");
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TRANSACTIONID"), (String)"The RequestDTO must contain a TRANSACTIONID");
        PayPalPaymentRequest request = this.buildBasicRequest(paymentRequestDTO, PayPalTransactionType.CREDIT);
        request.setMethodType(PayPalMethodType.REFUND);
        request.setRefundType(PayPalRefundType.getInstance((String)paymentRequestDTO.getAdditionalFields().get("REFUNDTYPE")));
        request.setTransactionID((String)paymentRequestDTO.getAdditionalFields().get("TRANSACTIONID"));
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS);
        PayPalPaymentResponse response = (PayPalPaymentResponse)this.process(request);
        this.setCommonPaymentResponse(response, responseDTO);
        responseDTO.successful(response.isSuccessful());
        responseDTO.paymentTransactionType(PaymentTransactionType.REFUND);
        this.setDecisionInformation(response, responseDTO);
        this.setRefundInformation(response, responseDTO);
        return responseDTO;
    }

    public PaymentResponseDTO voidPayment(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TRANSACTIONID"), (String)"The RequestDTO must contain a TRANSACTIONID");
        PayPalPaymentRequest request = this.buildBasicRequest(paymentRequestDTO, PayPalTransactionType.VOIDTRANSACTION);
        request.setMethodType(PayPalMethodType.VOID);
        request.setTransactionID((String)paymentRequestDTO.getAdditionalFields().get("TRANSACTIONID"));
        PayPalPaymentResponse response = (PayPalPaymentResponse)this.process(request);
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS);
        this.setCommonPaymentResponse(response, responseDTO);
        responseDTO.successful(response.isSuccessful());
        responseDTO.paymentTransactionType(PaymentTransactionType.VOID);
        this.setDecisionInformation(response, responseDTO);
        return responseDTO;
    }
}

