/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionConfirmationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransactionService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.PayPalExpressConfiguration;
import org.springframework.stereotype.Service;

@Service(value="blPayPalExpressTransactionConfirmationService")
public class PayPalExpressTransactionConfirmationServiceImpl
implements PaymentGatewayTransactionConfirmationService {
    @Resource(name="blPayPalExpressConfiguration")
    protected PayPalExpressConfiguration configuration;
    @Resource(name="blPayPalExpressTransactionService")
    protected PaymentGatewayTransactionService transactionService;

    public PaymentResponseDTO confirmTransaction(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PaymentResponseDTO responseDTO = null;
        if (this.configuration.isPerformAuthorizeAndCapture()) {
            responseDTO = this.transactionService.authorizeAndCapture(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        } else {
            responseDTO = this.transactionService.authorize(paymentRequestDTO);
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE);
        }
        return responseDTO;
    }
}

