/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayReportingService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.AbstractPayPalExpressService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalExpressPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blPayPalExpressReportingService")
public class PayPalExpressReportingServiceImpl
extends AbstractPayPalExpressService
implements PaymentGatewayReportingService {
    public String getServiceName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public PaymentResponseDTO findDetailsByTransaction(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        Assert.isTrue((boolean)paymentRequestDTO.getAdditionalFields().containsKey("TOKEN"), (String)"The RequestDTO must contain a TOKEN");
        PayPalDetailsRequest detailsRequest = new PayPalDetailsRequest();
        detailsRequest.setMethodType(PayPalMethodType.DETAILS);
        detailsRequest.setToken((String)paymentRequestDTO.getAdditionalFields().get("TOKEN"));
        PayPalDetailsResponse response = (PayPalDetailsResponse)this.process(detailsRequest);
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS);
        this.setCommonDetailsResponse(response, responseDTO);
        return responseDTO;
    }
}

