/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayHostedService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.AbstractPayPalExpressService;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalTransactionType;
import org.springframework.stereotype.Service;

@Service(value="blPayPalExpressHostedService")
public class PayPalExpressHostedServiceImpl
extends AbstractPayPalExpressService
implements PaymentGatewayHostedService {
    protected static final Log LOG = LogFactory.getLog(PayPalExpressHostedServiceImpl.class);

    public String getServiceName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public PaymentResponseDTO requestHostedEndpoint(PaymentRequestDTO paymentRequestDTO) throws PaymentException {
        PayPalTransactionType transactionType = PayPalTransactionType.AUTHORIZEANDCAPTURE;
        if (!this.configuration.isPerformAuthorizeAndCapture()) {
            transactionType = PayPalTransactionType.AUTHORIZE;
        }
        PaymentResponseDTO responseDTO = this.commonAuthorizeOrSale(paymentRequestDTO, transactionType, null, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Request to PayPal Express Checkout Hosted Endpoint with raw response: " + responseDTO.getRawResponse()));
        }
        return responseDTO;
    }
}

