/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.payment.service.gateway.PayPalExpressConfiguration;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalExpressPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalShippingDisplayType;
import org.springframework.stereotype.Service;

@Service(value="blPayPalExpressConfiguration")
public class PayPalExpressConfigurationImpl
implements PayPalExpressConfiguration {
    protected int failureReportingThreshold = 1;
    protected boolean performAuthorizeAndCapture = true;

    @Override
    public String getServerUrl() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.serverUrl");
    }

    @Override
    public String getUserRedirectUrl() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.userRedirectUrl");
    }

    @Override
    public String getLibVersion() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.libVersion");
    }

    @Override
    public String getPassword() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.password");
    }

    @Override
    public String getUser() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.user");
    }

    @Override
    public String getSignature() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.signature");
    }

    @Override
    public Boolean getUseRelativeUrls() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"gateway.paypal.expressCheckout.useRelativeUrls");
    }

    @Override
    public String getReturnUrl() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.returnUrl");
    }

    @Override
    public String getCancelUrl() {
        return BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.cancelUrl");
    }

    @Override
    public PayPalShippingDisplayType getShippingDisplayType() {
        String shippingType = BLCSystemProperty.resolveSystemProperty((String)"gateway.paypal.expressCheckout.shippingDisplayType");
        PayPalShippingDisplayType displayType = PayPalShippingDisplayType.getInstance(shippingType);
        if (displayType != null) {
            return displayType;
        }
        return PayPalShippingDisplayType.NO_DISPLAY;
    }

    @Override
    public String getTotalType() {
        return "Total";
    }

    @Override
    public Map<String, String> getAdditionalConfig() {
        HashMap<String, String> additionalConfigs = new HashMap<String, String>();
        additionalConfigs.put("HDRBORDERCOLOR", "FFFFFF");
        additionalConfigs.put("HDRBACKCOLOR", "FFFFFF");
        additionalConfigs.put("PAYFLOWCOLOR", "FFFFFF");
        return additionalConfigs;
    }

    public boolean handlesAuthorize() {
        return true;
    }

    public boolean handlesCapture() {
        return true;
    }

    public boolean handlesAuthorizeAndCapture() {
        return true;
    }

    public boolean handlesReverseAuthorize() {
        return true;
    }

    public boolean handlesVoid() {
        return true;
    }

    public boolean handlesRefund() {
        return true;
    }

    public boolean handlesPartialCapture() {
        return false;
    }

    public boolean handlesMultipleShipment() {
        return false;
    }

    public boolean handlesRecurringPayment() {
        return false;
    }

    public boolean handlesSavedCustomerPayment() {
        return false;
    }

    public boolean isPerformAuthorizeAndCapture() {
        return this.performAuthorizeAndCapture;
    }

    public void setPerformAuthorizeAndCapture(boolean performAuthorizeAndCapture) {
        this.performAuthorizeAndCapture = performAuthorizeAndCapture;
    }

    public int getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public void setFailureReportingThreshold(int failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public boolean handlesMultiplePayments() {
        return false;
    }

    public PaymentGatewayType getGatewayType() {
        return PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS;
    }
}

