/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.LineItemDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.AbstractExternalPaymentGatewayCall;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.PayPalExpressConfiguration;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalExpressPaymentGatewayType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalRequestGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalResponseGenerator;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalPayerAddress;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalItemRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalShippingRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalSummaryRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalTransactionType;
import org.springframework.util.Assert;

public abstract class AbstractPayPalExpressService
extends AbstractExternalPaymentGatewayCall<PayPalRequest, PayPalResponse> {
    private static final Log LOG = LogFactory.getLog(AbstractPayPalExpressService.class);
    @Resource(name="blPayPalExpressConfiguration")
    protected PayPalExpressConfiguration configuration;
    @Resource(name="blPayPalExpressRequestGenerator")
    protected PayPalRequestGenerator requestGenerator;
    @Resource(name="blPayPalExpressResponseGenerator")
    protected PayPalResponseGenerator responseGenerator;

    public Integer getFailureReportingThreshold() {
        return this.configuration.getFailureReportingThreshold();
    }

    public PayPalResponse communicateWithVendor(PayPalRequest paymentRequest) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(this.getServerUrl());
        List<NameValuePair> nvps = this.requestGenerator.buildRequest(paymentRequest);
        postMethod.setRequestBody(nvps.toArray(new NameValuePair[nvps.size()]));
        httpClient.executeMethod((HttpMethod)postMethod);
        String responseString = postMethod.getResponseBodyAsString();
        return this.responseGenerator.buildResponse(responseString, paymentRequest);
    }

    public String getServerUrl() {
        return this.configuration.getServerUrl();
    }

    protected PayPalPaymentRequest buildBasicRequest(PaymentRequestDTO requestDTO, PayPalTransactionType transactionType) {
        Assert.isTrue((requestDTO.getOrderId() != null ? 1 : 0) != 0, (String)"The Order ID for the paypal request cannot be null");
        Assert.isTrue((requestDTO.getTransactionTotal() != null ? 1 : 0) != 0, (String)"The Transaction Total for the paypal request cannot be null");
        if (requestDTO.getOrderId() != null) {
            Assert.isTrue((requestDTO.getOrderId().length() <= 127 ? 1 : 0) != 0, (String)"The reference number for the paypal request cannot be greater than 127 characters");
        }
        PayPalPaymentRequest request = new PayPalPaymentRequest();
        request.setTransactionType(transactionType);
        request.setOrderId(requestDTO.getOrderId());
        request.setCurrency(requestDTO.getOrderCurrencyCode());
        request.setCompleteCheckoutOnCallback(requestDTO.isCompleteCheckoutOnCallback());
        PayPalSummaryRequest summaryRequest = new PayPalSummaryRequest();
        summaryRequest.setGrandTotal(new Money(requestDTO.getTransactionTotal(), requestDTO.getOrderCurrencyCode()));
        request.setSummaryRequest(summaryRequest);
        return request;
    }

    protected PaymentResponseDTO commonAuthorizeOrSale(PaymentRequestDTO requestDTO, PayPalTransactionType transactionType, String token, String payerId) throws PaymentException {
        PayPalPaymentRequest request = this.buildBasicRequest(requestDTO, transactionType);
        Assert.isTrue((requestDTO.getOrderSubtotal() != null ? 1 : 0) != 0, (String)"Must specify an Order Subtotal value on the PaymentRequestDTO");
        Assert.isTrue((requestDTO.getShippingTotal() != null ? 1 : 0) != 0, (String)"Must specify a Shipping Total value on the PaymentRequestDTO");
        Assert.isTrue((requestDTO.getTaxTotal() != null ? 1 : 0) != 0, (String)"Must specify a Tax Total value on the PaymentRequestDTO");
        request.getSummaryRequest().setSubTotal(new Money(requestDTO.getOrderSubtotal(), requestDTO.getOrderCurrencyCode()));
        request.getSummaryRequest().setTotalShipping(new Money(requestDTO.getShippingTotal(), requestDTO.getOrderCurrencyCode()));
        request.getSummaryRequest().setTotalTax(new Money(requestDTO.getTaxTotal(), requestDTO.getOrderCurrencyCode()));
        if (token == null && payerId == null) {
            if (PayPalTransactionType.AUTHORIZE.equals(transactionType)) {
                request.setMethodType(PayPalMethodType.AUTHORIZATION);
            } else {
                request.setMethodType(PayPalMethodType.CHECKOUT);
            }
        } else {
            request.setMethodType(PayPalMethodType.PROCESS);
            if (PayPalTransactionType.AUTHORIZE.equals(transactionType)) {
                request.setSecondaryMethodType(PayPalMethodType.AUTHORIZATION);
            } else {
                request.setSecondaryMethodType(PayPalMethodType.CHECKOUT);
            }
            request.setPayerID(payerId);
            request.setToken(token);
        }
        for (LineItemDTO lineItem : requestDTO.getLineItems()) {
            PayPalItemRequest itemRequest = new PayPalItemRequest();
            itemRequest.setDescription(lineItem.getDescription());
            itemRequest.setShortDescription(lineItem.getShortDescription());
            itemRequest.setQuantity(Long.parseLong(lineItem.getQuantity()));
            itemRequest.setUnitPrice(new Money(lineItem.getAmount(), requestDTO.getOrderCurrencyCode()));
            itemRequest.setSystemId(lineItem.getSystemId());
            request.getItemRequests().add(itemRequest);
        }
        if (requestDTO.shipToPopulated()) {
            PayPalShippingRequest shippingRequest = new PayPalShippingRequest();
            shippingRequest.setShipToName(requestDTO.getShipTo().getAddressFirstName() + " " + requestDTO.getShipTo().getAddressLastName());
            shippingRequest.setShipToStreet(requestDTO.getShipTo().getAddressLine1());
            shippingRequest.setShipToStreet2(requestDTO.getShipTo().getAddressLine2());
            shippingRequest.setShipToCity(requestDTO.getShipTo().getAddressCityLocality());
            shippingRequest.setShipToState(requestDTO.getShipTo().getAddressStateRegion());
            shippingRequest.setShipToZip(requestDTO.getShipTo().getAddressPostalCode());
            shippingRequest.setShipToCountryCode(requestDTO.getShipTo().getAddressCountryCode());
            shippingRequest.setShipToPhoneNum(requestDTO.getShipTo().getAddressPhone());
            request.getShippingRequests().add(shippingRequest);
        }
        PayPalPaymentResponse response = (PayPalPaymentResponse)this.process(request);
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, PayPalExpressPaymentGatewayType.PAYPAL_EXPRESS);
        this.setCommonPaymentResponse(response, responseDTO);
        responseDTO.successful(response.isSuccessful());
        if (PayPalTransactionType.AUTHORIZE.equals(transactionType)) {
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE);
        } else if (PayPalTransactionType.AUTHORIZEANDCAPTURE.equals(transactionType)) {
            responseDTO.paymentTransactionType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE);
        }
        if (PayPalMethodType.PROCESS.equals(request.getMethodType())) {
            this.setDecisionInformation(response, responseDTO);
        } else if (PayPalMethodType.CHECKOUT.equals(request.getMethodType()) || PayPalMethodType.AUTHORIZATION.equals(request.getMethodType())) {
            responseDTO.responseMap("REDIRECTURL", response.getUserRedirectUrl());
        }
        return responseDTO;
    }

    protected void setCommonPaymentResponse(PayPalPaymentResponse response, PaymentResponseDTO responseDTO) {
        try {
            responseDTO.rawResponse(URLDecoder.decode(response.getRawResponse(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        responseDTO.responseMap("TOKEN", response.getResponseToken());
        responseDTO.responseMap("CORRELATIONID", response.getCorrelationId());
    }

    protected void setCommonDetailsResponse(PayPalDetailsResponse response, PaymentResponseDTO responseDTO) {
        try {
            responseDTO.rawResponse(URLDecoder.decode(response.getRawResponse(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (response.getAddresses() != null && !response.getAddresses().isEmpty()) {
            PayPalPayerAddress payerAddress = response.getAddresses().get(0);
            responseDTO.shipTo().addressFirstName(payerAddress.getName()).addressLine1(payerAddress.getStreet()).addressLine2(payerAddress.getStreet2()).addressCityLocality(payerAddress.getCity()).addressStateRegion(payerAddress.getState()).addressPostalCode(payerAddress.getZip()).addressCountryCode(payerAddress.getCountryCode()).addressPhone(payerAddress.getPhoneNumber()).done();
            if (payerAddress.getAddressStatus() != null) {
                responseDTO.getShipTo().additionalFields("PAYMENTREQUEST_n_ADDRESSSTATUS", (Object)payerAddress.getAddressStatus().getType());
            }
        }
        if (response.getPaymentDetails() != null) {
            String itemTotal = response.getPaymentDetails().getItemTotal() != null ? response.getPaymentDetails().getItemTotal().toString() : "";
            String shippingDiscount = response.getPaymentDetails().getShippingDiscount() != null ? response.getPaymentDetails().getShippingDiscount().toString() : "";
            String shippingTotal = response.getPaymentDetails().getShippingTotal() != null ? response.getPaymentDetails().getShippingTotal().toString() : "";
            String totalTax = response.getPaymentDetails().getTotalTax() != null ? response.getPaymentDetails().getTotalTax().toString() : "";
            responseDTO.amount(response.getPaymentDetails().getAmount()).orderId(response.getPaymentDetails().getOrderId()).completeCheckoutOnCallback(response.getPaymentDetails().isCompleteCheckoutOnCallback()).responseMap("PAYMENTREQUEST_n_ALLOWEDPAYMENTMETHOD", response.getPaymentDetails().getPaymentMethod()).responseMap("PAYMENTREQUEST_n_PAYMENTREQUESTID", response.getPaymentDetails().getPaymentRequestId()).responseMap("PAYMENTREQUEST_n_TRANSACTIONID", response.getPaymentDetails().getTransactionId()).responseMap("PAYMENTREQUEST_n_ITEMAMT", itemTotal).responseMap("PAYMENTREQUEST_n_SHIPDISCAMT", shippingDiscount).responseMap("PAYMENTREQUEST_n_SHIPPINGAMT", shippingTotal).responseMap("PAYMENTREQUEST_n_TAXAMT", totalTax);
        }
        if (response.getCheckoutStatusType() != null) {
            responseDTO.responseMap("CHECKOUTSTATUS", response.getCheckoutStatusType().getType());
        }
        String paypalAdjustment = response.getPayPalAdjustment() != null ? response.getPayPalAdjustment().toString() : "";
        String payerStatus = response.getPayerStatus() != null ? response.getPayerStatus().toString() : "";
        ((PaymentResponseDTO)responseDTO.customer().firstName(response.getPayerFirstName()).lastName(response.getPayerLastName()).companyName(response.getBusiness()).phone(response.getPhoneNumber()).email(response.getEmailAddress()).done()).responseMap("TOKEN", response.getResponseToken()).responseMap("PAYERID", response.getPayerId()).responseMap("NOTE", response.getNote()).responseMap("PAYPALADJUSTMENT", paypalAdjustment).responseMap("PAYERSTATUS", payerStatus);
    }

    protected void setDecisionInformation(PayPalPaymentResponse response, PaymentResponseDTO responseDTO) {
        responseDTO.responseMap("TRANSACTIONID", response.getPaymentInfo().getTransactionId());
        if (response.getPaymentInfo().getTotalAmount() != null) {
            responseDTO.amount(response.getPaymentInfo().getTotalAmount());
        }
        if (response.getPaymentInfo().getParentTransactionId() != null) {
            responseDTO.responseMap("PARENTTRANSACTIONID", response.getPaymentInfo().getParentTransactionId());
        }
        if (response.getPaymentInfo().getReceiptId() != null) {
            responseDTO.responseMap("RECEIPTID", response.getPaymentInfo().getReceiptId());
        }
        if (response.getPaymentInfo().getExchangeRate() != null) {
            responseDTO.responseMap("EXCHANGERATE", response.getPaymentInfo().getExchangeRate().toString());
        }
        if (response.getPaymentInfo().getPaymentStatusType() != null) {
            responseDTO.responseMap("PAYMENTSTATUS", response.getPaymentInfo().getPaymentStatusType().getType());
        }
        if (response.getPaymentInfo().getPendingReasonType() != null) {
            responseDTO.responseMap("PENDINGREASON", response.getPaymentInfo().getPendingReasonType().getType());
        }
        if (response.getPaymentInfo().getReasonCodeType() != null) {
            responseDTO.responseMap("REASONCODE", response.getPaymentInfo().getReasonCodeType().getType());
        }
        if (response.getPaymentInfo().getHoldDecisionType() != null) {
            responseDTO.responseMap("HOLDDECISION", response.getPaymentInfo().getHoldDecisionType().getType());
        }
        if (response.getPaymentInfo().getFeeAmount() != null) {
            responseDTO.responseMap("FEEAMT", response.getPaymentInfo().getFeeAmount().toString());
        }
        if (response.getPaymentInfo().getSettleAmount() != null) {
            responseDTO.responseMap("SETTLEAMT", response.getPaymentInfo().getSettleAmount().toString());
        }
        if (response.getPaymentInfo().getTaxAmount() != null) {
            responseDTO.responseMap("TAXAMT", response.getPaymentInfo().getTaxAmount().toString());
        }
    }

    protected void setRefundInformation(PayPalPaymentResponse response, PaymentResponseDTO responseDTO) {
        if (response.getRefundInfo().getRefundTransactionId() != null) {
            responseDTO.responseMap("REFUNDTRANSACTIONID", response.getRefundInfo().getRefundTransactionId());
        }
        if (response.getRefundInfo().getGrossRefundAmount() != null) {
            responseDTO.amount(new Money(response.getRefundInfo().getGrossRefundAmount().toString()));
            responseDTO.responseMap("GROSSREFUNDAMT", response.getRefundInfo().getGrossRefundAmount().toString());
        }
        if (response.getRefundInfo().getFeeRefundAmount() != null) {
            responseDTO.responseMap("FEEREFUNDAMT", response.getRefundInfo().getFeeRefundAmount().toString());
        }
        if (response.getRefundInfo().getNetRefundAmount() != null) {
            responseDTO.responseMap("NETREFUNDAMT", response.getRefundInfo().getNetRefundAmount().toString());
        }
        if (response.getRefundInfo().getTotalRefundAmount() != null) {
            responseDTO.responseMap("TOTALREFUNDEDAMT", response.getRefundInfo().getTotalRefundAmount().toString());
        }
        if (response.getRefundInfo().getRefundInfo() != null) {
            responseDTO.responseMap("REFUNDINFO", response.getRefundInfo().getRefundInfo());
        }
        if (response.getRefundInfo().getRefundStatusType() != null) {
            responseDTO.responseMap("REFUNDSTATUS", response.getRefundInfo().getRefundStatusType().getType());
        }
        if (response.getRefundInfo().getPendingReasonType() != null) {
            responseDTO.responseMap("PENDINGREASON", response.getRefundInfo().getPendingReasonType().getType());
        }
    }
}

