/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.openadmin.server.service.persistence.module.provider;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.broadleafcommerce.openadmin.server.service.persistence.module.provider.RuleFieldExtractionUtility;
import org.broadleafcommerce.openadmin.web.rulebuilder.dto.DataDTO;
import org.broadleafcommerce.openadmin.web.rulebuilder.dto.DataWrapper;
import org.broadleafcommerce.openadmin.web.rulebuilder.dto.ExpressionDTO;
import org.junit.Assert;
import org.junit.Test;

public class RuleFieldPersistenceProviderTest {
    @Test
    public void testJSONToDataDTOTranslation() throws JsonGenerationException, JsonMappingException, IOException {
        String json = "{\"data\":[{\"id\":1,\"quantity\":1,\"groupOperator\":\"AND\",\"groups\":[{\"id\":null,\"quantity\":null,\"groupOperator\":null,\"groups\":[],\"name\":\"category.name\",\"operator\":\"IEQUALS\",\"value\":\"merchandise\"}]}]}";
        DataWrapper expected = new DataWrapper();
        DataDTO leftSide = new DataDTO();
        leftSide.setId(Long.valueOf(1L));
        leftSide.setQuantity(Integer.valueOf(1));
        leftSide.setGroupOperator("AND");
        ExpressionDTO rightSide = new ExpressionDTO();
        rightSide.setName("category.name");
        rightSide.setOperator("IEQUALS");
        rightSide.setValue("merchandise");
        leftSide.setGroups(new ArrayList<DataDTO>(Arrays.asList(rightSide)));
        expected.setData(new ArrayList<DataDTO>(Arrays.asList(leftSide)));
        RuleFieldExtractionUtility extractor = new RuleFieldExtractionUtility();
        DataWrapper wrapper = extractor.convertJsonToDataWrapper(json);
        Assert.assertEquals((Object)expected, (Object)wrapper);
        String expectedJson = "{\"data\":[{\"id\":1,\"quantity\":1,\"groupOperator\":\"AND\",\"groups\":[{\"id\":null,\"quantity\":null,\"groupOperator\":null,\"groups\":[],\"name\":\"category.name\",\"operator\":\"IEQUALS\",\"value\":\"merchandise\",\"start\":null,\"end\":null}]}],\"error\":null,\"rawMvel\":null}";
        String serializedWrapperJson = wrapper.serialize();
        Assert.assertEquals((Object)expectedJson, (Object)serializedWrapperJson);
        DataWrapper serializedWrapper = extractor.convertJsonToDataWrapper(serializedWrapperJson);
        Assert.assertEquals((Object)expected, (Object)serializedWrapper);
    }
}

