/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.broadleafcommerce.openadmin.server.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.client.service.UtilityService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * @author jfischer
 */
@Service("blUtilityRemoteService")
public class UtilityRemoteService implements ApplicationContextAware, UtilityService {

    private static final Log LOG = LogFactory.getLog(UtilityRemoteService.class);

    private ApplicationContext applicationContext;

    protected String storeFrontWebAppContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getWebAppContext() throws ServiceException {
        try {
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getContextPath();
        } catch (Exception e) {
            LOG.error("problem performing operation", e);
            throw new ServiceException("problem performing operation", e);
        }
    }

    public String getStoreFrontWebAppContext() {
        return storeFrontWebAppContext;
    }

    public void setStoreFrontWebAppContext(String storeFrontWebAppContext) {
        this.storeFrontWebAppContext = storeFrontWebAppContext;
    }
}
