/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.nullPaymentGateway.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayHostedService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

@Component(value="blNullPaymentGatewayHostedActionProcessor")
public class NullPaymentGatewayHostedActionProcessor
extends AbstractAttributeModifierAttrProcessor {
    @Resource(name="blNullPaymentGatewayHostedService")
    private PaymentGatewayHostedService paymentGatewayHostedService;

    public NullPaymentGatewayHostedActionProcessor() {
        super("null_payment_hosted_action");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        PaymentRequestDTO requestDTO = (PaymentRequestDTO)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
        String url = "";
        if (requestDTO != null) {
            if (element.getAttributeValue("complete_checkout") != null) {
                Boolean completeCheckout = (Boolean)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue("complete_checkout"));
                element.removeAttribute("complete_checkout");
                requestDTO.completeCheckoutOnCallback(completeCheckout.booleanValue());
            }
            try {
                PaymentResponseDTO responseDTO = this.paymentGatewayHostedService.requestHostedEndpoint(requestDTO);
                url = ((String)responseDTO.getResponseMap().get("HOSTED_REDIRECT_URL")).toString();
            }
            catch (PaymentException e) {
                throw new RuntimeException("Unable to Create Null Payment Gateway Hosted Link", e);
            }
        }
        attrs.put("action", url);
        return attrs;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

