/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.nullPaymentGateway.web.controller.mock.processor;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.CreditCardValidator;
import org.broadleafcommerce.payment.service.gateway.NullPaymentGatewayConfiguration;
import org.joda.time.DateTime;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="blNullMockProcessorController")
public class NullMockProcessorController {
    @Resource(name="blNullPaymentGatewayConfiguration")
    protected NullPaymentGatewayConfiguration paymentGatewayConfiguration;

    @RequestMapping(value={"/null-checkout/process"}, method={RequestMethod.POST})
    @ResponseBody
    public String processTransparentRedirectForm(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        String transactionAmount = "";
        String orderId = "";
        String billingFirstName = "";
        String billingLastName = "";
        String billingAddressLine1 = "";
        String billingAddressLine2 = "";
        String billingCity = "";
        String billingState = "";
        String billingZip = "";
        String billingCountry = "";
        String shippingFirstName = "";
        String shippingLastName = "";
        String shippingAddressLine1 = "";
        String shippingAddressLine2 = "";
        String shippingCity = "";
        String shippingState = "";
        String shippingZip = "";
        String shippingCountry = "";
        String creditCardName = "";
        String creditCardNumber = "";
        String creditCardExpDate = "";
        String creditCardCVV = "";
        String cardType = "UNKNOWN";
        String resultMessage = "";
        String resultSuccess = "";
        String gatewayTransactionId = UUID.randomUUID().toString();
        if (paramMap.get("TRANSACTION_AMT") != null && ((String[])paramMap.get("TRANSACTION_AMT")).length > 0) {
            transactionAmount = ((String[])paramMap.get("TRANSACTION_AMT"))[0];
        }
        if (paramMap.get("ORDER_ID") != null && ((String[])paramMap.get("ORDER_ID")).length > 0) {
            orderId = ((String[])paramMap.get("ORDER_ID"))[0];
        }
        if (paramMap.get("NULL_BILLING_FIRST_NAME") != null && ((String[])paramMap.get("NULL_BILLING_FIRST_NAME")).length > 0) {
            billingFirstName = ((String[])paramMap.get("NULL_BILLING_FIRST_NAME"))[0];
        }
        if (paramMap.get("NULL_BILLING_LAST_NAME") != null && ((String[])paramMap.get("NULL_BILLING_LAST_NAME")).length > 0) {
            billingLastName = ((String[])paramMap.get("NULL_BILLING_LAST_NAME"))[0];
        }
        if (paramMap.get("NULL_BILLING_ADDRESS_LINE1") != null && ((String[])paramMap.get("NULL_BILLING_ADDRESS_LINE1")).length > 0) {
            billingAddressLine1 = ((String[])paramMap.get("NULL_BILLING_ADDRESS_LINE1"))[0];
        }
        if (paramMap.get("NULL_BILLING_ADDRESS_LINE2") != null && ((String[])paramMap.get("NULL_BILLING_ADDRESS_LINE2")).length > 0) {
            billingAddressLine2 = ((String[])paramMap.get("NULL_BILLING_ADDRESS_LINE2"))[0];
        }
        if (paramMap.get("NULL_BILLING_CITY") != null && ((String[])paramMap.get("NULL_BILLING_CITY")).length > 0) {
            billingCity = ((String[])paramMap.get("NULL_BILLING_CITY"))[0];
        }
        if (paramMap.get("NULL_BILLING_STATE") != null && ((String[])paramMap.get("NULL_BILLING_STATE")).length > 0) {
            billingState = ((String[])paramMap.get("NULL_BILLING_STATE"))[0];
        }
        if (paramMap.get("NULL_BILLING_ZIP") != null && ((String[])paramMap.get("NULL_BILLING_ZIP")).length > 0) {
            billingZip = ((String[])paramMap.get("NULL_BILLING_ZIP"))[0];
        }
        if (paramMap.get("NULL_BILLING_COUNTRY") != null && ((String[])paramMap.get("NULL_BILLING_COUNTRY")).length > 0) {
            billingCountry = ((String[])paramMap.get("NULL_BILLING_COUNTRY"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_FIRST_NAME") != null && ((String[])paramMap.get("NULL_SHIPPING_FIRST_NAME")).length > 0) {
            shippingFirstName = ((String[])paramMap.get("NULL_SHIPPING_FIRST_NAME"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_LAST_NAME") != null && ((String[])paramMap.get("NULL_SHIPPING_LAST_NAME")).length > 0) {
            shippingLastName = ((String[])paramMap.get("NULL_SHIPPING_LAST_NAME"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_ADDRESS_LINE1") != null && ((String[])paramMap.get("NULL_SHIPPING_ADDRESS_LINE1")).length > 0) {
            shippingAddressLine1 = ((String[])paramMap.get("NULL_SHIPPING_ADDRESS_LINE1"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_ADDRESS_LINE2") != null && ((String[])paramMap.get("NULL_SHIPPING_ADDRESS_LINE2")).length > 0) {
            shippingAddressLine2 = ((String[])paramMap.get("NULL_SHIPPING_ADDRESS_LINE2"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_CITY") != null && ((String[])paramMap.get("NULL_SHIPPING_CITY")).length > 0) {
            shippingCity = ((String[])paramMap.get("NULL_SHIPPING_CITY"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_STATE") != null && ((String[])paramMap.get("NULL_SHIPPING_STATE")).length > 0) {
            shippingState = ((String[])paramMap.get("NULL_SHIPPING_STATE"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_ZIP") != null && ((String[])paramMap.get("NULL_SHIPPING_ZIP")).length > 0) {
            shippingZip = ((String[])paramMap.get("NULL_SHIPPING_ZIP"))[0];
        }
        if (paramMap.get("NULL_SHIPPING_COUNTRY") != null && ((String[])paramMap.get("NULL_SHIPPING_COUNTRY")).length > 0) {
            shippingCountry = ((String[])paramMap.get("NULL_SHIPPING_COUNTRY"))[0];
        }
        if (paramMap.get("CREDIT_CARD_NAME") != null && ((String[])paramMap.get("CREDIT_CARD_NAME")).length > 0) {
            creditCardName = ((String[])paramMap.get("CREDIT_CARD_NAME"))[0];
        }
        if (paramMap.get("CREDIT_CARD_NUMBER") != null && ((String[])paramMap.get("CREDIT_CARD_NUMBER")).length > 0) {
            creditCardNumber = ((String[])paramMap.get("CREDIT_CARD_NUMBER"))[0];
        }
        if (paramMap.get("CREDIT_CARD_EXP_DATE") != null && ((String[])paramMap.get("CREDIT_CARD_EXP_DATE")).length > 0) {
            creditCardExpDate = ((String[])paramMap.get("CREDIT_CARD_EXP_DATE"))[0];
        }
        if (paramMap.get("CREDIT_CARD_CVV") != null && ((String[])paramMap.get("CREDIT_CARD_CVV")).length > 0) {
            creditCardCVV = ((String[])paramMap.get("CREDIT_CARD_CVV"))[0];
        }
        CreditCardValidator visaValidator = new CreditCardValidator(2);
        CreditCardValidator amexValidator = new CreditCardValidator(1);
        CreditCardValidator mcValidator = new CreditCardValidator(4);
        CreditCardValidator discoverValidator = new CreditCardValidator(8);
        if (StringUtils.isNotBlank((String)transactionAmount) && StringUtils.isNotBlank((String)creditCardNumber) && StringUtils.isNotBlank((String)creditCardExpDate)) {
            boolean validCard = false;
            if (visaValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "VISA";
            } else if (amexValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "AMEX";
            } else if (mcValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "MASTERCARD";
            } else if (discoverValidator.isValid(creditCardNumber)) {
                validCard = true;
                cardType = "DISCOVER";
            }
            boolean validDateFormat = false;
            boolean validDate = false;
            String[] parsedDate = creditCardExpDate.split("/");
            if (parsedDate.length == 2) {
                String expMonth = parsedDate[0];
                String expYear = parsedDate[1];
                try {
                    DateTime expirationDate = new DateTime(Integer.parseInt("20" + expYear), Integer.parseInt(expMonth), 1, 0, 0);
                    expirationDate = expirationDate.dayOfMonth().withMaximumValue();
                    validDate = expirationDate.isAfterNow();
                    validDateFormat = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!validDate || !validDateFormat) {
                transactionAmount = "0";
                resultMessage = "cart.payment.expiration.invalid";
                resultSuccess = "false";
            } else if (!validCard) {
                transactionAmount = "0";
                resultMessage = "cart.payment.card.invalid";
                resultSuccess = "false";
            } else {
                resultMessage = "Success!";
                resultSuccess = "true";
            }
        } else {
            transactionAmount = "0";
            resultMessage = "cart.payment.invalid";
            resultSuccess = "false";
        }
        StringBuffer response = new StringBuffer();
        response.append("<!DOCTYPE HTML>");
        response.append("<!--[if lt IE 7]> <html class=\"no-js lt-ie9 lt-ie8 lt-ie7\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if IE 7]> <html class=\"no-js lt-ie9 lt-ie8\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if IE 8]> <html class=\"no-js lt-ie9\" lang=\"en\"> <![endif]-->");
        response.append("<!--[if gt IE 8]><!--> <html class=\"no-js\" lang=\"en\"> <!--<![endif]-->");
        response.append("<body>");
        response.append("<form action=\"" + this.paymentGatewayConfiguration.getTransparentRedirectReturnUrl() + "\" method=\"POST\" id=\"NullPaymentGatewayRedirectForm\" name=\"NullPaymentGatewayRedirectForm\">");
        response.append("<input type=\"hidden\" name=\"TRANSACTION_AMT\" value=\"" + transactionAmount + "\"/>");
        response.append("<input type=\"hidden\" name=\"ORDER_ID\" value=\"" + orderId + "\"/>");
        response.append("<input type=\"hidden\" name=\"GATEWAY_TRANSACTION_ID\" value=\"" + gatewayTransactionId + "\"/>");
        response.append("<input type=\"hidden\" name=\"MESSAGE\" value=\"" + resultMessage + "\"/>");
        response.append("<input type=\"hidden\" name=\"SUCCESS\" value=\"" + resultSuccess + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_FIRST_NAME\" value=\"" + billingFirstName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_LAST_NAME\" value=\"" + billingLastName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_ADDRESS_LINE1\" value=\"" + billingAddressLine1 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_ADDRESS_LINE2\" value=\"" + billingAddressLine2 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_CITY\" value=\"" + billingCity + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_STATE\" value=\"" + billingState + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_ZIP\" value=\"" + billingZip + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_BILLING_COUNTRY\" value=\"" + billingCountry + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_FIRST_NAME\" value=\"" + shippingFirstName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_LAST_NAME\" value=\"" + shippingLastName + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_ADDRESS_LINE1\" value=\"" + shippingAddressLine1 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_ADDRESS_LINE2\" value=\"" + shippingAddressLine2 + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_CITY\" value=\"" + shippingCity + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_STATE\" value=\"" + shippingState + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_ZIP\" value=\"" + shippingZip + "\"/>");
        response.append("<input type=\"hidden\" name=\"NULL_SHIPPING_COUNTRY\" value=\"" + shippingCountry + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_NAME\" value=\"" + creditCardName + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_LAST_FOUR\" value=\"" + StringUtils.right((String)creditCardNumber, (int)4) + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_TYPE\" value=\"" + cardType + "\"/>");
        response.append("<input type=\"hidden\" name=\"CREDIT_CARD_EXP_DATE\" value=\"" + creditCardExpDate + "\"/>");
        response.append("<input type=\"submit\" value=\"Please Click Here To Complete Checkout\"/>");
        response.append("</form>");
        response.append("<script type=\"text/javascript\">");
        response.append("document.getElementById('NullPaymentGatewayRedirectForm').submit();");
        response.append("</script>");
        response.append("</body>");
        response.append("</html>");
        return response.toString();
    }
}

