/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponsePrintService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.NullPaymentGatewayConfiguration;
import org.broadleafcommerce.vendor.nullPaymentGateway.service.payment.NullPaymentGatewayType;
import org.springframework.stereotype.Service;

@Service(value="blNullPaymentGatewayWebResponseService")
public class NullPaymentGatewayWebResponseServiceImpl
implements PaymentGatewayWebResponseService {
    @Resource(name="blPaymentGatewayWebResponsePrintService")
    protected PaymentGatewayWebResponsePrintService webResponsePrintService;
    @Resource(name="blNullPaymentGatewayConfiguration")
    protected NullPaymentGatewayConfiguration configuration;

    public PaymentResponseDTO translateWebResponse(HttpServletRequest request) throws PaymentException {
        Object[] msg;
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, NullPaymentGatewayType.NULL_GATEWAY).rawResponse(this.webResponsePrintService.printRequest(request));
        Map paramMap = request.getParameterMap();
        Money amount = Money.ZERO;
        if (paramMap.containsKey("TRANSACTION_AMT")) {
            String amt = ((String[])paramMap.get("TRANSACTION_AMT"))[0];
            amount = new Money(amt);
        }
        boolean approved = false;
        if (paramMap.containsKey("SUCCESS") && ArrayUtils.contains((Object[])(msg = (String[])paramMap.get("SUCCESS")), (Object)"true")) {
            approved = true;
        }
        PaymentTransactionType type = PaymentTransactionType.AUTHORIZE_AND_CAPTURE;
        if (!this.configuration.isPerformAuthorizeAndCapture()) {
            type = PaymentTransactionType.AUTHORIZE;
        }
        ((PaymentResponseDTO)responseDTO.successful(approved).amount(amount).paymentTransactionType(type).orderId(this.parse(paramMap, "ORDER_ID")).responseMap("GATEWAY_TRANSACTION_ID", this.parse(paramMap, "GATEWAY_TRANSACTION_ID")).responseMap("MESSAGE", this.parse(paramMap, "MESSAGE")).billTo().addressFirstName(this.parse(paramMap, "NULL_BILLING_FIRST_NAME")).addressLastName(this.parse(paramMap, "NULL_BILLING_LAST_NAME")).addressLine1(this.parse(paramMap, "NULL_BILLING_ADDRESS_LINE1")).addressLine2(this.parse(paramMap, "NULL_BILLING_ADDRESS_LINE2")).addressCityLocality(this.parse(paramMap, "NULL_BILLING_CITY")).addressStateRegion(this.parse(paramMap, "NULL_BILLING_STATE")).addressPostalCode(this.parse(paramMap, "NULL_BILLING_ZIP")).addressCountryCode(this.parse(paramMap, "NULL_BILLING_COUNTRY")).done()).creditCard().creditCardHolderName(this.parse(paramMap, "CREDIT_CARD_NAME")).creditCardLastFour(this.parse(paramMap, "CREDIT_CARD_LAST_FOUR")).creditCardType(this.parse(paramMap, "CREDIT_CARD_TYPE")).creditCardExpDate(this.parse(paramMap, "CREDIT_CARD_EXP_DATE")).done();
        return responseDTO;
    }

    protected String parse(Map<String, String[]> paramMap, String param) {
        if (paramMap.containsKey(param)) {
            return paramMap.get(param)[0];
        }
        return null;
    }
}

