/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.AddressDTO;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayTransparentRedirectService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.payment.service.gateway.NullPaymentGatewayConfiguration;
import org.broadleafcommerce.vendor.nullPaymentGateway.service.payment.NullPaymentGatewayType;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="blNullPaymentGatewayTransparentRedirectService")
public class NullPaymentGatewayTransparentRedirectServiceImpl
implements PaymentGatewayTransparentRedirectService {
    @Resource(name="blNullPaymentGatewayConfiguration")
    protected NullPaymentGatewayConfiguration configuration;

    public PaymentResponseDTO createAuthorizeForm(PaymentRequestDTO requestDTO) throws PaymentException {
        return this.createCommonTRFields(requestDTO);
    }

    public PaymentResponseDTO createAuthorizeAndCaptureForm(PaymentRequestDTO requestDTO) throws PaymentException {
        return this.createCommonTRFields(requestDTO);
    }

    protected PaymentResponseDTO createCommonTRFields(PaymentRequestDTO requestDTO) {
        AddressDTO shipTo;
        Assert.isTrue((requestDTO.getTransactionTotal() != null ? 1 : 0) != 0, (String)"The Transaction Total on the Payment Request DTO must not be null");
        Assert.isTrue((requestDTO.getOrderId() != null ? 1 : 0) != 0, (String)"The Order ID on the Payment Request DTO must not be null");
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.CREDIT_CARD, NullPaymentGatewayType.NULL_GATEWAY).responseMap("ORDER_ID", requestDTO.getOrderId()).responseMap("TRANSACTION_AMT", requestDTO.getTransactionTotal()).responseMap("TRANSPARENT_REDIRECT_URL", this.configuration.getTransparentRedirectUrl());
        AddressDTO billTo = requestDTO.getBillTo();
        if (billTo != null) {
            responseDTO.responseMap("NULL_BILLING_FIRST_NAME", billTo.getAddressFirstName()).responseMap("NULL_BILLING_LAST_NAME", billTo.getAddressLastName()).responseMap("NULL_BILLING_ADDRESS_LINE1", billTo.getAddressLine1()).responseMap("NULL_BILLING_ADDRESS_LINE2", billTo.getAddressLine2()).responseMap("NULL_BILLING_CITY", billTo.getAddressCityLocality()).responseMap("NULL_BILLING_STATE", billTo.getAddressStateRegion()).responseMap("NULL_BILLING_ZIP", billTo.getAddressPostalCode()).responseMap("NULL_BILLING_COUNTRY", billTo.getAddressCountryCode());
        }
        if ((shipTo = requestDTO.getShipTo()) != null) {
            responseDTO.responseMap("NULL_SHIPPING_FIRST_NAME", shipTo.getAddressFirstName()).responseMap("NULL_SHIPPING_LAST_NAME", shipTo.getAddressLastName()).responseMap("NULL_SHIPPING_ADDRESS_LINE1", shipTo.getAddressLine1()).responseMap("NULL_SHIPPING_ADDRESS_LINE2", shipTo.getAddressLine2()).responseMap("NULL_SHIPPING_CITY", shipTo.getAddressCityLocality()).responseMap("NULL_SHIPPING_STATE", shipTo.getAddressStateRegion()).responseMap("NULL_SHIPPING_ZIP", shipTo.getAddressPostalCode()).responseMap("NULL_SHIPPING_COUNTRY", shipTo.getAddressCountryCode());
        }
        return responseDTO;
    }
}

