/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.gateway;

import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponsePrintService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayWebResponseService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.vendor.nullPaymentGateway.service.payment.NullPaymentGatewayType;
import org.springframework.stereotype.Service;

@Service(value="blNullPaymentGatewayHostedWebResponseService")
public class NullPaymentGatewayHostedWebResponseServiceImpl
implements PaymentGatewayWebResponseService {
    @Resource(name="blPaymentGatewayWebResponsePrintService")
    protected PaymentGatewayWebResponsePrintService webResponsePrintService;

    public PaymentResponseDTO translateWebResponse(HttpServletRequest request) throws PaymentException {
        PaymentResponseDTO responseDTO = new PaymentResponseDTO(PaymentType.THIRD_PARTY_ACCOUNT, NullPaymentGatewayType.NULL_HOSTED_GATEWAY).rawResponse(this.webResponsePrintService.printRequest(request));
        Map paramMap = request.getParameterMap();
        Money amount = Money.ZERO;
        if (paramMap.containsKey("TRANSACTION_AMT")) {
            String amt = ((String[])paramMap.get("TRANSACTION_AMT"))[0];
            amount = new Money(amt);
        }
        responseDTO.successful(true).completeCheckoutOnCallback(Boolean.parseBoolean(((String[])paramMap.get("COMPLETE_CHECKOUT_ON_CALLBACK"))[0])).amount(amount).paymentTransactionType(PaymentTransactionType.UNCONFIRMED).orderId(((String[])paramMap.get("ORDER_ID"))[0]).responseMap("MESSAGE", ((String[])paramMap.get("MESSAGE"))[0]);
        return responseDTO;
    }
}

