/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.tax.provider;

import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.config.domain.ModuleConfiguration;
import org.broadleafcommerce.common.i18n.domain.ISOCountry;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.domain.TaxType;
import org.broadleafcommerce.core.pricing.service.exception.TaxException;
import org.broadleafcommerce.core.pricing.service.tax.provider.TaxProvider;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.State;

public class SimpleTaxProvider
implements TaxProvider {
    protected Map<String, Double> itemPostalCodeTaxRateMap;
    protected Map<String, Double> itemCityTaxRateMap;
    protected Map<String, Double> itemStateTaxRateMap;
    protected Map<String, Double> itemCountryTaxRateMap;
    protected Map<String, Double> fulfillmentGroupPostalCodeTaxRateMap;
    protected Map<String, Double> fulfillmentGroupCityTaxRateMap;
    protected Map<String, Double> fulfillmentGroupStateTaxRateMap;
    protected Map<String, Double> fulfillmentGroupCountryTaxRateMap;
    protected Double defaultItemTaxRate;
    protected Double defaultFulfillmentGroupTaxRate;
    protected boolean taxFees;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfig;

    public boolean canRespond(ModuleConfiguration config) {
        return config == null;
    }

    @Override
    public Order calculateTaxForOrder(Order order, ModuleConfiguration config) throws TaxException {
        if (!order.getCustomer().isTaxExempt()) {
            for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                TaxDetail tax;
                BigDecimal factor;
                block9: {
                    TaxDetail tax2;
                    BigDecimal factor2;
                    for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                        block7: {
                            if (!this.isItemTaxable(fgItem) || (factor2 = this.determineItemTaxRate(fulfillmentGroup.getAddress())) == null || factor2.compareTo(BigDecimal.ZERO) == 0) continue;
                            for (TaxDetail detail : fgItem.getTaxes()) {
                                if (!detail.getType().equals(TaxType.COMBINED)) continue;
                                tax2 = detail;
                                break block7;
                            }
                            tax2 = (TaxDetail)this.entityConfig.createEntityInstance(TaxDetail.class.getName(), TaxDetail.class);
                            tax2.setType(TaxType.COMBINED);
                            fgItem.getTaxes().add(tax2);
                        }
                        tax2.setRate(factor2);
                        tax2.setAmount(fgItem.getTotalItemTaxableAmount().multiply(factor2));
                    }
                    for (FulfillmentGroupFee fgFee : fulfillmentGroup.getFulfillmentGroupFees()) {
                        block8: {
                            if (!this.isFeeTaxable(fgFee) || (factor2 = this.determineItemTaxRate(fulfillmentGroup.getAddress())) == null || factor2.compareTo(BigDecimal.ZERO) == 0) continue;
                            for (TaxDetail detail : fgFee.getTaxes()) {
                                if (!detail.getType().equals(TaxType.COMBINED)) continue;
                                tax2 = detail;
                                break block8;
                            }
                            tax2 = (TaxDetail)this.entityConfig.createEntityInstance(TaxDetail.class.getName(), TaxDetail.class);
                            tax2.setType(TaxType.COMBINED);
                            fgFee.getTaxes().add(tax2);
                        }
                        tax2.setRate(factor2);
                        tax2.setAmount(fgFee.getAmount().multiply(factor2));
                    }
                    factor = this.determineTaxRateForFulfillmentGroup(fulfillmentGroup);
                    if (factor == null || factor.compareTo(BigDecimal.ZERO) == 0) continue;
                    for (TaxDetail detail : fulfillmentGroup.getTaxes()) {
                        if (!detail.getType().equals(TaxType.COMBINED)) continue;
                        tax = detail;
                        break block9;
                    }
                    tax = (TaxDetail)this.entityConfig.createEntityInstance(TaxDetail.class.getName(), TaxDetail.class);
                    tax.setType(TaxType.COMBINED);
                    fulfillmentGroup.getTaxes().add(tax);
                }
                tax.setRate(factor);
                tax.setAmount(fulfillmentGroup.getFulfillmentPrice().multiply(factor));
            }
        }
        return order;
    }

    @Override
    public Order commitTaxForOrder(Order order, ModuleConfiguration config) throws TaxException {
        return order;
    }

    @Override
    public void cancelTax(Order order, ModuleConfiguration config) throws TaxException {
    }

    public Double lookupPostalCodeRate(Map<String, Double> postalCodeTaxRateMap, String postalCode) {
        if (postalCodeTaxRateMap != null && postalCode != null) {
            return postalCodeTaxRateMap.get(postalCode);
        }
        return null;
    }

    public Double lookupCityRate(Map<String, Double> cityTaxRateMap, String city) {
        if (cityTaxRateMap != null && city != null) {
            city = city.toUpperCase();
            return cityTaxRateMap.get(city);
        }
        return null;
    }

    public Double lookupStateRate(Map<String, Double> stateTaxRateMap, State state) {
        if (stateTaxRateMap != null && state != null && state.getAbbreviation() != null) {
            String stateAbbr = state.getAbbreviation().toUpperCase();
            Double rate = stateTaxRateMap.get(stateAbbr);
            if (rate == null && state.getName() != null) {
                String stateName = state.getName().toUpperCase();
                return stateTaxRateMap.get(stateName);
            }
            return rate;
        }
        return null;
    }

    public Double lookupStateRate(Map<String, Double> stateTaxRateMap, String stateProvinceRegion) {
        if (stateTaxRateMap != null && StringUtils.isNotBlank((String)stateProvinceRegion)) {
            return stateTaxRateMap.get(stateProvinceRegion);
        }
        return null;
    }

    public Double lookupCountryRate(Map<String, Double> countryTaxRateMap, Country country) {
        if (countryTaxRateMap != null && country != null && country.getAbbreviation() != null) {
            String cntryAbbr = country.getAbbreviation().toUpperCase();
            Double rate = countryTaxRateMap.get(cntryAbbr);
            if (rate == null && country.getName() != null) {
                String countryName = country.getName().toUpperCase();
                return countryTaxRateMap.get(countryName);
            }
            return rate;
        }
        return null;
    }

    public Double lookupCountryRate(Map<String, Double> countryTaxRateMap, ISOCountry isoCountry) {
        if (countryTaxRateMap != null && isoCountry != null && isoCountry.getAlpha2() != null) {
            String cntryAbbr = isoCountry.getAlpha2().toUpperCase();
            Double rate = countryTaxRateMap.get(cntryAbbr);
            if (rate == null && isoCountry.getName() != null) {
                String countryName = isoCountry.getName().toUpperCase();
                return countryTaxRateMap.get(countryName);
            }
            return rate;
        }
        return null;
    }

    protected boolean isItemTaxable(FulfillmentGroupItem item) {
        return item.getOrderItem().isTaxable();
    }

    protected boolean isFeeTaxable(FulfillmentGroupFee fee) {
        return fee.isTaxable();
    }

    public BigDecimal determineItemTaxRate(Address address) {
        if (address != null) {
            Double postalCodeRate = this.lookupPostalCodeRate(this.itemPostalCodeTaxRateMap, address.getPostalCode());
            if (postalCodeRate != null) {
                return BigDecimal.valueOf(postalCodeRate);
            }
            Double cityCodeRate = this.lookupCityRate(this.itemCityTaxRateMap, address.getCity());
            if (cityCodeRate != null) {
                return BigDecimal.valueOf(cityCodeRate);
            }
            Double stateCodeRate = StringUtils.isNotBlank((String)address.getStateProvinceRegion()) ? this.lookupStateRate(this.itemStateTaxRateMap, address.getStateProvinceRegion()) : this.lookupStateRate(this.itemStateTaxRateMap, address.getState());
            if (stateCodeRate != null) {
                return BigDecimal.valueOf(stateCodeRate);
            }
            Double countryCodeRate = address.getIsoCountryAlpha2() != null ? this.lookupCountryRate(this.itemCountryTaxRateMap, address.getIsoCountryAlpha2()) : this.lookupCountryRate(this.itemCountryTaxRateMap, address.getCountry());
            if (countryCodeRate != null) {
                return BigDecimal.valueOf(countryCodeRate);
            }
        }
        if (this.defaultItemTaxRate != null) {
            return BigDecimal.valueOf(this.defaultItemTaxRate);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal determineTaxRateForFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        boolean isTaxable = true;
        if (fulfillmentGroup.isShippingPriceTaxable() != null) {
            isTaxable = fulfillmentGroup.isShippingPriceTaxable();
        }
        if (isTaxable) {
            Address address = fulfillmentGroup.getAddress();
            if (address != null) {
                Double postalCodeRate = this.lookupPostalCodeRate(this.fulfillmentGroupPostalCodeTaxRateMap, address.getPostalCode());
                if (postalCodeRate != null) {
                    return BigDecimal.valueOf(postalCodeRate);
                }
                Double cityCodeRate = this.lookupCityRate(this.fulfillmentGroupCityTaxRateMap, address.getCity());
                if (cityCodeRate != null) {
                    return BigDecimal.valueOf(cityCodeRate);
                }
                Double stateCodeRate = StringUtils.isNotBlank((String)address.getStateProvinceRegion()) ? this.lookupStateRate(this.fulfillmentGroupStateTaxRateMap, address.getStateProvinceRegion()) : this.lookupStateRate(this.fulfillmentGroupStateTaxRateMap, address.getState());
                if (stateCodeRate != null) {
                    return BigDecimal.valueOf(stateCodeRate);
                }
                Double countryCodeRate = address.getIsoCountryAlpha2() != null ? this.lookupCountryRate(this.fulfillmentGroupCountryTaxRateMap, address.getIsoCountryAlpha2()) : this.lookupCountryRate(this.fulfillmentGroupCountryTaxRateMap, address.getCountry());
                if (countryCodeRate != null) {
                    return BigDecimal.valueOf(countryCodeRate);
                }
            }
            if (this.defaultFulfillmentGroupTaxRate != null) {
                return BigDecimal.valueOf(this.defaultFulfillmentGroupTaxRate);
            }
        }
        return BigDecimal.ZERO;
    }

    public Map<String, Double> getItemPostalCodeTaxRateMap() {
        return this.itemPostalCodeTaxRateMap;
    }

    public void setItemPostalCodeTaxRateMap(Map<String, Double> itemPostalCodeTaxRateMap) {
        this.itemPostalCodeTaxRateMap = itemPostalCodeTaxRateMap;
    }

    public Map<String, Double> getItemCityTaxRateMap() {
        return this.itemCityTaxRateMap;
    }

    public void setItemCityTaxRateMap(Map<String, Double> itemCityTaxRateMap) {
        this.itemCityTaxRateMap = itemCityTaxRateMap;
    }

    public Map<String, Double> getItemStateTaxRateMap() {
        return this.itemStateTaxRateMap;
    }

    public void setItemStateTaxRateMap(Map<String, Double> itemStateTaxRateMap) {
        this.itemStateTaxRateMap = itemStateTaxRateMap;
    }

    public Map<String, Double> getItemCountryTaxRateMap() {
        return this.itemCountryTaxRateMap;
    }

    public void setItemCountryTaxRateMap(Map<String, Double> itemCountryTaxRateMap) {
        this.itemCountryTaxRateMap = itemCountryTaxRateMap;
    }

    public Map<String, Double> getFulfillmentGroupPostalCodeTaxRateMap() {
        return this.fulfillmentGroupPostalCodeTaxRateMap;
    }

    public void setFulfillmentGroupPostalCodeTaxRateMap(Map<String, Double> fulfillmentGroupPostalCodeTaxRateMap) {
        this.fulfillmentGroupPostalCodeTaxRateMap = fulfillmentGroupPostalCodeTaxRateMap;
    }

    public Map<String, Double> getFulfillmentGroupCityTaxRateMap() {
        return this.fulfillmentGroupCityTaxRateMap;
    }

    public void setFulfillmentGroupCityTaxRateMap(Map<String, Double> fulfillmentGroupCityTaxRateMap) {
        this.fulfillmentGroupCityTaxRateMap = fulfillmentGroupCityTaxRateMap;
    }

    public Map<String, Double> getFulfillmentGroupStateTaxRateMap() {
        return this.fulfillmentGroupStateTaxRateMap;
    }

    public void setFulfillmentGroupStateTaxRateMap(Map<String, Double> fulfillmentGroupStateTaxRateMap) {
        this.fulfillmentGroupStateTaxRateMap = fulfillmentGroupStateTaxRateMap;
    }

    public Map<String, Double> getFulfillmentGroupCountryTaxRateMap() {
        return this.fulfillmentGroupCountryTaxRateMap;
    }

    public void setFulfillmentGroupCountryTaxRateMap(Map<String, Double> fulfillmentGroupCountryTaxRateMap) {
        this.fulfillmentGroupCountryTaxRateMap = fulfillmentGroupCountryTaxRateMap;
    }

    public Double getDefaultItemTaxRate() {
        return this.defaultItemTaxRate;
    }

    public void setDefaultItemTaxRate(Double defaultItemTaxRate) {
        this.defaultItemTaxRate = defaultItemTaxRate;
    }

    public Double getDefaultFulfillmentGroupTaxRate() {
        return this.defaultFulfillmentGroupTaxRate;
    }

    public void setDefaultFulfillmentGroupTaxRate(Double defaultFulfillmentGroupTaxRate) {
        this.defaultFulfillmentGroupTaxRate = defaultFulfillmentGroupTaxRate;
    }
}

