/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.broadleafcommerce.core.order.domain.OrderLock;

@Entity
@Table(name="BLC_ORDER_LOCK")
@Inheritance(strategy=InheritanceType.JOINED)
public class OrderLockImpl
implements OrderLock {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    OrderLockPk orderLockPK = new OrderLockPk();
    @Column(name="LOCKED")
    protected Character locked = Character.valueOf('N');
    @Column(name="LAST_UPDATED")
    protected Long lastUpdated;

    @Override
    public Long getOrderId() {
        return this.orderLockPK.getOrderId();
    }

    @Override
    public void setOrderId(Long orderId) {
        this.orderLockPK.setOrderId(orderId);
    }

    @Override
    public Boolean getLocked() {
        if (this.locked == null || this.locked.charValue() == 'N') {
            return false;
        }
        return true;
    }

    @Override
    public void setLocked(Boolean locked) {
        this.locked = locked == null || locked == false ? Character.valueOf('N') : Character.valueOf('Y');
    }

    @Override
    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public void setLastUpdated(Long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Override
    public String getKey() {
        return this.orderLockPK.getKey();
    }

    @Override
    public void setKey(String nodeKey) {
        this.orderLockPK.setKey(nodeKey);
    }

    @Embeddable
    public static class OrderLockPk
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Column(name="ORDER_ID")
        protected Long orderId;
        @Column(name="LOCK_KEY")
        protected String key;

        public Long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && this.getClass().isAssignableFrom(obj.getClass())) {
                OrderLockPk other = (OrderLockPk)obj;
                return new EqualsBuilder().append((Object)this.orderId, (Object)other.orderId).append((Object)this.key, (Object)other.key).build();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.orderId).append((Object)this.key).build();
        }
    }
}

