/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class OfferTimeZoneType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OfferTimeZoneType> TYPES = new LinkedHashMap<String, OfferTimeZoneType>();
    public static final OfferTimeZoneType SERVER = new OfferTimeZoneType("SERVER", "Server");
    public static final OfferTimeZoneType APPLICATION = new OfferTimeZoneType("APPLICATION", "Application Supplied");
    public static final OfferTimeZoneType CST = new OfferTimeZoneType("CST", "CST", true);
    public static final OfferTimeZoneType UTC = new OfferTimeZoneType("UTC", "UTC", true);
    private String type;
    private String friendlyType;
    private Boolean javaStandardTimeZone;

    public static OfferTimeZoneType getInstance(String type) {
        return TYPES.get(type);
    }

    public OfferTimeZoneType() {
    }

    public OfferTimeZoneType(String type, String friendlyType) {
        this(type, friendlyType, false);
    }

    public OfferTimeZoneType(String type, String friendlyType, Boolean javaStandardTimeZone) {
        this.friendlyType = friendlyType;
        this.setType(type);
        this.setJavaStandardTimeZone(javaStandardTimeZone);
    }

    public void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    public Boolean getJavaStandardTimeZone() {
        return this.javaStandardTimeZone;
    }

    public void setJavaStandardTimeZone(Boolean javaStandardTimeZone) {
        this.javaStandardTimeZone = javaStandardTimeZone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        OfferTimeZoneType other = (OfferTimeZoneType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

