/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableOrderAdjustmentImpl
implements PromotableOrderAdjustment {
    private static final long serialVersionUID = 1L;
    protected PromotableCandidateOrderOffer promotableCandidateOrderOffer;
    protected PromotableOrder promotableOrder;
    protected Money adjustmentValue;
    protected Offer offer;
    protected boolean roundOfferValues = true;
    protected int roundingScale = 2;
    protected RoundingMode roundingMode = RoundingMode.HALF_EVEN;

    public PromotableOrderAdjustmentImpl(PromotableCandidateOrderOffer promotableCandidateOrderOffer, PromotableOrder promotableOrder) {
        assert (promotableOrder != null);
        assert (promotableCandidateOrderOffer != null);
        this.promotableCandidateOrderOffer = promotableCandidateOrderOffer;
        this.promotableOrder = promotableOrder;
        this.offer = promotableCandidateOrderOffer.getOffer();
        this.computeAdjustmentValue();
    }

    public PromotableOrderAdjustmentImpl(PromotableCandidateOrderOffer promotableCandidateOrderOffer, PromotableOrder promotableOrder, Money adjustmentValue) {
        this(promotableCandidateOrderOffer, promotableOrder);
        if (promotableOrder.isIncludeOrderAndItemAdjustments()) {
            this.adjustmentValue = adjustmentValue;
        }
    }

    @Override
    public PromotableOrder getPromotableOrder() {
        return this.promotableOrder;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    protected void computeAdjustmentValue() {
        this.adjustmentValue = new Money(this.promotableOrder.getOrderCurrency());
        Money currentOrderValue = this.promotableOrder.calculateSubtotalWithAdjustments();
        currentOrderValue = currentOrderValue.subtract(this.promotableOrder.calculateOrderAdjustmentTotal());
        if (this.offer.getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
            this.adjustmentValue = new Money(this.offer.getValue(), this.promotableOrder.getOrderCurrency());
        } else if (this.offer.getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
            BigDecimal offerValue = currentOrderValue.getAmount().multiply(this.offer.getValue().divide(new BigDecimal("100"), 5, RoundingMode.HALF_EVEN));
            if (this.isRoundOfferValues()) {
                offerValue = offerValue.setScale(this.roundingScale, this.roundingMode);
            }
            this.adjustmentValue = new Money(offerValue, this.promotableOrder.getOrderCurrency(), 5);
        }
        if (currentOrderValue.lessThan(this.adjustmentValue)) {
            this.adjustmentValue = currentOrderValue;
        }
    }

    @Override
    public Money getAdjustmentValue() {
        return this.adjustmentValue;
    }

    public boolean isRoundOfferValues() {
        return this.roundOfferValues;
    }

    public void setRoundingScale(int roundingScale) {
        this.roundingScale = roundingScale;
    }

    public int getRoundingScale() {
        return this.roundingScale;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public boolean isCombinable() {
        Boolean combinable = this.offer.isCombinableWithOtherOffers();
        return combinable != null && combinable != false;
    }

    @Override
    public boolean isTotalitarian() {
        Boolean totalitarian = this.offer.isTotalitarianOffer();
        return totalitarian != null && totalitarian != false;
    }
}

