/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.logging.SupportLogManager;
import org.broadleafcommerce.common.logging.SupportLogger;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.util.DialectHelper;
import org.broadleafcommerce.common.util.dao.TypedQueryBuilder;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.dao.ProductDaoExtensionHandler;
import org.broadleafcommerce.core.catalog.dao.ProductDaoExtensionManager;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.broadleafcommerce.core.search.domain.SearchCriteria;
import org.springframework.stereotype.Repository;

@Repository(value="blProductDao")
public class ProductDaoImpl
implements ProductDao {
    private static final SupportLogger logger = SupportLogManager.getLogger((String)"Enterprise", ProductDaoImpl.class);
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;
    @Resource(name="blProductDaoExtensionManager")
    protected ProductDaoExtensionManager extensionManager;
    @Resource(name="blDialectHelper")
    protected DialectHelper dialectHelper;
    protected Long currentDateResolution = 10000L;
    protected Date cachedDate = SystemTime.asDate();

    @Override
    public Product save(Product product) {
        return (Product)this.em.merge((Object)product);
    }

    @Override
    public Product readProductById(Long productId) {
        return (Product)this.em.find(ProductImpl.class, (Object)productId);
    }

    @Override
    public Product readProductByExternalId(String externalId) {
        TypedQuery query = new TypedQueryBuilder(Product.class, "product").addRestriction("product.defaultSku.externalId", "=", (Object)externalId).toQuery(this.em);
        try {
            return (Product)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Product> readProductsByIds(List<Long> productIds) {
        if (productIds == null || productIds.size() == 0) {
            return null;
        }
        if (productIds.size() > 100) {
            logger.warn((Object)("Not recommended to use the readProductsByIds method for long lists of productIds, since Hibernate is required to transform the distinct results. The list of requestedproduct ids was (" + productIds.size() + ") in length."));
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root product = criteria.from(ProductImpl.class);
        Fetch fetchParent = product.fetch("defaultSku", JoinType.LEFT);
        if (!this.dialectHelper.isOracle() && !this.dialectHelper.isSqlServer()) {
            fetchParent.fetch("skuMedia", JoinType.LEFT);
        }
        criteria.select((Selection)product);
        criteria.where((Expression)product.get("id").as(Long.class).in((Collection)this.sandBoxHelper.mergeCloneIds(this.em, ProductImpl.class, productIds.toArray(new Long[productIds.size()]))));
        if (!this.dialectHelper.isOracle() && !this.dialectHelper.isSqlServer()) {
            criteria.distinct(true);
        }
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByName(String searchName) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME", Product.class);
        query.setParameter("name", (Object)(searchName + '%'));
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByName(@Nonnull String searchName, @Nonnull int limit, @Nonnull int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME", Product.class);
        query.setParameter("name", (Object)(searchName + '%'));
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId) {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readActiveProductsByCategoryInternal(categoryId, currentDate);
    }

    @Override
    @Deprecated
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate) {
        return this.readActiveProductsByCategoryInternal(categoryId, currentDate);
    }

    protected List<Product> readActiveProductsByCategoryInternal(Long categoryId, Date currentDate) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)this.sandBoxHelper.mergeCloneIds(this.em, CategoryImpl.class, new Long[]{categoryId}));
        query.setParameter("currentDate", (Object)currentDate);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readFilteredActiveProductsByQuery(String query, SearchCriteria searchCriteria) {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readFilteredActiveProductsByQueryInternal(query, currentDate, searchCriteria);
    }

    @Override
    @Deprecated
    public List<Product> readFilteredActiveProductsByQuery(String query, Date currentDate, SearchCriteria searchCriteria) {
        return this.readFilteredActiveProductsByQueryInternal(query, currentDate, searchCriteria);
    }

    protected List<Product> readFilteredActiveProductsByQueryInternal(String query, Date currentDate, SearchCriteria searchCriteria) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root product = criteria.from(ProductImpl.class);
        Join sku = product.join("defaultSku");
        criteria.select((Selection)product);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        String lq = query.toLowerCase();
        restrictions.add(builder.or((Expression)builder.like(builder.lower(sku.get("name").as(String.class)), '%' + lq + '%'), (Expression)builder.like(builder.lower(sku.get("longDescription").as(String.class)), '%' + lq + '%')));
        this.attachSearchCriteria(searchCriteria, (From<?, ? extends Product>)product, (From<?, ? extends Sku>)sku, (List<Predicate>)restrictions);
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        this.attachOrderBy(searchCriteria, (From<?, ? extends Product>)product, (Path<? extends Sku>)sku, (CriteriaQuery<?>)criteria);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        TypedQuery typedQuery = this.em.createQuery(criteria);
        return typedQuery.getResultList();
    }

    @Override
    public List<Product> readFilteredActiveProductsByCategory(Long categoryId, SearchCriteria searchCriteria) {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readFilteredActiveProductsByCategoryInternal(categoryId, currentDate, searchCriteria);
    }

    @Override
    @Deprecated
    public List<Product> readFilteredActiveProductsByCategory(Long categoryId, Date currentDate, SearchCriteria searchCriteria) {
        return this.readFilteredActiveProductsByCategoryInternal(categoryId, currentDate, searchCriteria);
    }

    protected List<Product> readFilteredActiveProductsByCategoryInternal(Long categoryId, Date currentDate, SearchCriteria searchCriteria) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root productXref = criteria.from(CategoryProductXrefImpl.class);
        Join product = productXref.join("product");
        Join sku = product.join("defaultSku");
        Join category = productXref.join("category");
        criteria.select((Selection)product);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        restrictions.add(category.get("id").in((Collection)this.sandBoxHelper.mergeCloneIds(this.em, CategoryImpl.class, new Long[]{categoryId})));
        this.attachSearchCriteria(searchCriteria, (From<?, ? extends Product>)product, (From<?, ? extends Sku>)sku, (List<Predicate>)restrictions);
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        this.attachOrderBy(searchCriteria, (From<?, ? extends Product>)product, (Path<? extends Sku>)sku, (CriteriaQuery<?>)criteria);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        TypedQuery typedQuery = this.em.createQuery(criteria);
        return typedQuery.getResultList();
    }

    protected void attachActiveRestriction(Date currentDate, Path<? extends Product> product, Path<? extends Sku> sku, List<Predicate> restrictions) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        restrictions.add(builder.or((Expression)builder.isNull((Expression)product.get("archiveStatus").get("archived")), (Expression)builder.equal((Expression)product.get("archiveStatus").get("archived"), (Object)Character.valueOf('N'))));
        restrictions.add(builder.lessThan(sku.get("activeStartDate").as(Date.class), (Comparable)currentDate));
        restrictions.add(builder.or((Expression)builder.isNull((Expression)sku.get("activeEndDate")), (Expression)builder.greaterThan(sku.get("activeEndDate").as(Date.class), (Comparable)currentDate)));
    }

    protected void attachOrderBy(SearchCriteria searchCriteria, From<?, ? extends Product> product, Path<? extends Sku> sku, CriteriaQuery<?> criteria) {
        if (StringUtils.isNotBlank((String)searchCriteria.getSortQuery())) {
            CriteriaBuilder builder = this.em.getCriteriaBuilder();
            ArrayList<Order> sorts = new ArrayList<Order>();
            String sortQueries = searchCriteria.getSortQuery();
            for (String sortQuery : sortQueries.split(",")) {
                Path<? extends Sku> pathToUse;
                String[] sort = sortQuery.split(" ");
                if (sort.length != 2) continue;
                String key = sort[0];
                boolean asc = sort[1].toLowerCase().contains("asc");
                if (key.contains("defaultSku.")) {
                    pathToUse = sku;
                    key = key.substring("defaultSku.".length());
                } else {
                    if (!key.contains("product.")) continue;
                    pathToUse = product;
                    key = key.substring("product.".length());
                }
                if (asc) {
                    sorts.add(builder.asc((Expression)pathToUse.get(key)));
                    continue;
                }
                sorts.add(builder.desc((Expression)pathToUse.get(key)));
            }
            criteria.orderBy(sorts.toArray(new Order[sorts.size()]));
        }
    }

    protected void attachSearchCriteria(SearchCriteria searchCriteria, From<?, ? extends Product> product, From<?, ? extends Sku> sku, List<Predicate> restrictions) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
            From<?, ? extends Product> pathToUse;
            String key = entry.getKey();
            ArrayList<String> eqValues = new ArrayList<String>();
            ArrayList<String[]> rangeValues = new ArrayList<String[]>();
            if (key.contains("defaultSku.")) {
                pathToUse = sku;
                key = key.substring("defaultSku.".length());
            } else if (key.contains("productAttributes.")) {
                pathToUse = product.join("productAttributes");
                key = key.substring("productAttributes.".length());
                restrictions.add(builder.equal(pathToUse.get("name").as(String.class), (Object)key));
                key = "value";
            } else {
                if (!key.contains("product.")) continue;
                pathToUse = product;
                key = key.substring("product.".length());
            }
            for (String value : entry.getValue()) {
                if (value.contains("range[")) {
                    String[] rangeValue = new String[]{value.substring(value.indexOf("[") + 1, value.indexOf(":")), value.substring(value.indexOf(":") + 1, value.indexOf("]"))};
                    rangeValues.add(rangeValue);
                    continue;
                }
                eqValues.add(value);
            }
            if (eqValues.size() > 0) {
                restrictions.add(pathToUse.get(key).in(eqValues));
            }
            ArrayList<Predicate> rangeRestrictions = new ArrayList<Predicate>();
            for (String[] range : rangeValues) {
                BigDecimal min = new BigDecimal(range[0]);
                BigDecimal max = null;
                if (range[1] != null && !range[1].equals("null")) {
                    max = new BigDecimal(range[1]);
                }
                Predicate minRange = builder.greaterThan(pathToUse.get(key).as(BigDecimal.class), (Comparable)min);
                Predicate maxRange = null;
                if (max != null) {
                    maxRange = builder.lessThan(pathToUse.get(key).as(BigDecimal.class), (Comparable)max);
                    rangeRestrictions.add(builder.and((Expression)minRange, (Expression)maxRange));
                    continue;
                }
                rangeRestrictions.add(minRange);
            }
            if (rangeRestrictions.size() <= 0) continue;
            restrictions.add(builder.or(rangeRestrictions.toArray(new Predicate[rangeRestrictions.size()])));
        }
    }

    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId, int limit, int offset) {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readActiveProductsByCategoryInternal(categoryId, currentDate, limit, offset);
    }

    @Override
    @Deprecated
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate, int limit, int offset) {
        return this.readActiveProductsByCategoryInternal(categoryId, currentDate, limit, offset);
    }

    public List<Product> readActiveProductsByCategoryInternal(Long categoryId, Date currentDate, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)this.sandBoxHelper.mergeCloneIds(this.em, CategoryImpl.class, new Long[]{categoryId}));
        query.setParameter("currentDate", (Object)currentDate);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByCategory(Long categoryId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)this.sandBoxHelper.mergeCloneIds(this.em, CategoryImpl.class, new Long[]{categoryId}));
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByCategory(Long categoryId, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)this.sandBoxHelper.mergeCloneIds(this.em, CategoryImpl.class, new Long[]{categoryId}));
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public void delete(Product product) {
        ((Status)product).setArchived(Character.valueOf('Y'));
        this.em.merge((Object)product);
    }

    @Override
    public Product create(ProductType productType) {
        return (Product)this.entityConfiguration.createEntityInstance(productType.getType());
    }

    @Override
    public List<ProductBundle> readAutomaticProductBundles() {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        TypedQuery query = this.em.createNamedQuery("BC_READ_AUTOMATIC_PRODUCT_BUNDLES", ProductBundle.class);
        query.setParameter("currentDate", (Object)currentDate);
        query.setParameter("autoBundle", (Object)Boolean.TRUE);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    @Override
    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }

    @Override
    public List<Product> findProductByURI(String uri) {
        if (this.extensionManager != null) {
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((ProductDaoExtensionHandler)this.extensionManager.getProxy()).findProductByURI(uri, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        String urlKey = uri.substring(uri.lastIndexOf(47));
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_OUTGOING_URL");
        query.setParameter("url", (Object)uri);
        query.setParameter("urlKey", (Object)urlKey);
        query.setParameter("currentDate", (Object)DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution));
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<Product> readAllActiveProducts(int page, int pageSize) {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readAllActiveProductsInternal(page, pageSize, currentDate);
    }

    @Override
    @Deprecated
    public List<Product> readAllActiveProducts(int page, int pageSize, Date currentDate) {
        return this.readAllActiveProductsInternal(page, pageSize, currentDate);
    }

    protected List<Product> readAllActiveProductsInternal(int page, int pageSize, Date currentDate) {
        CriteriaQuery<Product> criteria = this.getCriteriaForActiveProducts(currentDate);
        int firstResult = page * pageSize;
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.setFirstResult(firstResult).setMaxResults(pageSize).getResultList();
    }

    @Override
    public List<Product> readAllActiveProducts() {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readAllActiveProductsInternal(currentDate);
    }

    @Override
    @Deprecated
    public List<Product> readAllActiveProducts(Date currentDate) {
        return this.readAllActiveProductsInternal(currentDate);
    }

    protected List<Product> readAllActiveProductsInternal(Date currentDate) {
        CriteriaQuery<Product> criteria = this.getCriteriaForActiveProducts(currentDate);
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public Long readCountAllActiveProducts() {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readCountAllActiveProductsInternal(currentDate);
    }

    @Override
    @Deprecated
    public Long readCountAllActiveProducts(Date currentDate) {
        return this.readCountAllActiveProductsInternal(currentDate);
    }

    protected Long readCountAllActiveProductsInternal(Date currentDate) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root product = criteria.from(ProductImpl.class);
        Join sku = product.join("defaultSku");
        criteria.select((Selection)builder.count((Expression)product));
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return (Long)query.getSingleResult();
    }

    protected CriteriaQuery<Product> getCriteriaForActiveProducts(Date currentDate) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root product = criteria.from(ProductImpl.class);
        Join sku = product.join("defaultSku");
        product.fetch("defaultSku");
        criteria.select((Selection)product);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        criteria.orderBy(new Order[]{builder.asc((Expression)product.get("id"))});
        return criteria;
    }
}

