/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.store.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.store.domain.Store;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_STORE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="StoreImpl_baseStore")
@Inheritance(strategy=InheritanceType.JOINED)
public class StoreImpl
implements Store {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="StoreId")
    @GenericGenerator(name="StoreId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="StoreImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.store.domain.StoreImpl")})
    @Column(name="STORE_ID", nullable=false)
    @AdminPresentation(friendlyName="StoreImpl_Store_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    private Long id;
    @Column(name="STORE_NAME", nullable=false)
    @AdminPresentation(friendlyName="StoreImpl_Store_Name", order=1000, group="StoreImpl_Store_General", groupOrder=1000, prominent=true, gridOrder=1, columnWidth="200px", requiredOverride=RequiredOverride.REQUIRED)
    private String name;
    @Column(name="ADDRESS_1")
    @AdminPresentation(friendlyName="StoreImpl_address1", order=2000, group="StoreImpl_Store_Location", groupOrder=2000, gridOrder=2, columnWidth="200px")
    private String address1;
    @Column(name="ADDRESS_2")
    @AdminPresentation(friendlyName="StoreImpl_address2", order=3000, group="StoreImpl_Store_Location", groupOrder=2000, gridOrder=3, columnWidth="200px")
    private String address2;
    @Column(name="STORE_CITY")
    @AdminPresentation(friendlyName="StoreImpl_city", order=4000, group="StoreImpl_Store_Location", groupOrder=2000, prominent=true, gridOrder=4)
    private String city;
    @Column(name="STORE_STATE")
    @AdminPresentation(friendlyName="StoreImpl_State", order=5000, group="StoreImpl_Store_Location", groupOrder=2000, prominent=true, gridOrder=5)
    private String state;
    @Column(name="STORE_ZIP")
    @AdminPresentation(friendlyName="StoreImpl_Zip", order=6000, group="StoreImpl_Store_Location", groupOrder=2000, prominent=true, gridOrder=6)
    private String zip;
    @Column(name="STORE_COUNTRY")
    @AdminPresentation(friendlyName="StoreImpl_Country", order=7000, group="StoreImpl_Store_Location", groupOrder=2000, gridOrder=7, columnWidth="200px")
    private String country;
    @Column(name="STORE_PHONE")
    @AdminPresentation(friendlyName="StoreImpl_Phone", order=8000, group="StoreImpl_Store_Location", groupOrder=2000, gridOrder=8, columnWidth="200px")
    private String phone;
    @Column(name="LATITUDE")
    @AdminPresentation(friendlyName="StoreImpl_lat", order=9000, tab="StoreImpl_Advanced_Tab", tabOrder=7000, group="StoreImpl_Store_Geocoding", groupOrder=3000, gridOrder=9, columnWidth="200px")
    private Double latitude;
    @Column(name="LONGITUDE")
    @AdminPresentation(friendlyName="StoreImpl_lng", order=10000, tab="StoreImpl_Advanced_Tab", tabOrder=7000, group="StoreImpl_Store_Geocoding", groupOrder=3000, gridOrder=10, columnWidth="200px")
    private Double longitude;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAddress1() {
        return this.address1;
    }

    @Override
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    @Override
    public String getAddress2() {
        return this.address2;
    }

    @Override
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public String getZip() {
        return this.zip;
    }

    @Override
    public void setZip(String zip) {
        this.zip = zip;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int NAME = 1000;
            public static final int ADDRESS_1 = 2000;
            public static final int ADDRESS_2 = 3000;
            public static final int CITY = 4000;
            public static final int STATE = 5000;
            public static final int ZIP = 6000;
            public static final int COUNTRY = 7000;
            public static final int PHONE = 8000;
            public static final int LATITUDE = 9000;
            public static final int LONGITUDE = 10000;
        }

        public static class Group {

            public static class Order {
                public static final int General = 1000;
                public static final int Location = 2000;
                public static final int Geocoding = 3000;
            }

            public static class Name {
                public static final String General = "StoreImpl_Store_General";
                public static final String Location = "StoreImpl_Store_Location";
                public static final String Geocoding = "StoreImpl_Store_Geocoding";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Advanced = 7000;
            }

            public static class Name {
                public static final String Advanced = "StoreImpl_Advanced_Tab";
            }
        }
    }
}

