/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.util.TableCreator;
import org.broadleafcommerce.common.util.TransactionUtils;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.NullOrderFactory;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.MergeCartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.OrderServiceExtensionHandler;
import org.broadleafcommerce.core.order.service.OrderServiceExtensionManager;
import org.broadleafcommerce.core.order.service.call.ActivityMessageDTO;
import org.broadleafcommerce.core.order.service.call.GiftWrapOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.IllegalCartOperationException;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.payment.dao.OrderPaymentDao;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.secure.Referenced;
import org.broadleafcommerce.core.payment.service.SecureOrderPaymentService;
import org.broadleafcommerce.core.pricing.service.PricingService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.ActivityMessages;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.Processor;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.hibernate.exception.LockAcquisitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blOrderService")
@ManagedResource(objectName="org.broadleafcommerce:name=OrderService", description="Order Service", currencyTimeLimit=15)
public class OrderServiceImpl
implements OrderService {
    private static final Log LOG = LogFactory.getLog(OrderServiceImpl.class);
    @Resource(name="blOrderPaymentDao")
    protected OrderPaymentDao paymentDao;
    @Resource(name="blOrderDao")
    protected OrderDao orderDao;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blNullOrderFactory")
    protected NullOrderFactory nullOrderFactory;
    @Resource(name="blPricingService")
    protected PricingService pricingService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    @Resource(name="blSecureOrderPaymentService")
    protected SecureOrderPaymentService securePaymentInfoService;
    @Resource(name="blMergeCartService")
    protected MergeCartService mergeCartService;
    @Resource(name="blOrderServiceExtensionManager")
    protected OrderServiceExtensionManager extensionManager;
    @Resource(name="blAddItemWorkflow")
    protected Processor addItemWorkflow;
    @Resource(name="blUpdateProductOptionsForItemWorkflow")
    private Processor updateProductOptionsForItemWorkflow;
    @Resource(name="blUpdateItemWorkflow")
    protected Processor updateItemWorkflow;
    @Resource(name="blRemoveItemWorkflow")
    protected Processor removeItemWorkflow;
    @Resource(name="blTransactionManager")
    protected PlatformTransactionManager transactionManager;
    @Value(value="${pricing.retry.count.for.lock.failure}")
    protected int pricingRetryCountForLockFailure = 3;
    @Value(value="${pricing.retry.wait.interval.for.lock.failure}")
    protected long pricingRetryWaitIntervalForLockFailure = 500L;
    protected boolean moveNamedOrderItems = true;
    protected boolean deleteEmptyNamedOrders = true;
    @Value(value="${automatically.merge.like.items}")
    protected boolean automaticallyMergeLikeItems;
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;

    @Override
    @Transactional(value="blTransactionManager")
    public Order createNewCartForCustomer(Customer customer) {
        return this.orderDao.createNewCartForCustomer(customer);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order createNamedOrderForCustomer(String name, Customer customer) {
        Order namedOrder = this.orderDao.create();
        namedOrder.setCustomer(customer);
        namedOrder.setName(name);
        namedOrder.setStatus(OrderStatus.NAMED);
        if (this.extensionManager != null) {
            ((OrderServiceExtensionHandler)this.extensionManager.getProxy()).attachAdditionalDataToNewNamedCart(customer, namedOrder);
        }
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            namedOrder.setLocale(BroadleafRequestContext.getBroadleafRequestContext().getLocale());
        }
        return this.orderDao.save(namedOrder);
    }

    @Override
    public Order findNamedOrderForCustomer(String name, Customer customer) {
        return this.orderDao.readNamedOrderForCustomer(customer, name);
    }

    @Override
    public Order findOrderById(Long orderId) {
        return this.orderDao.readOrderById(orderId);
    }

    @Override
    public Order findOrderById(Long orderId, boolean refresh) {
        return this.orderDao.readOrderById(orderId, refresh);
    }

    @Override
    public Order getNullOrder() {
        return this.nullOrderFactory.getNullOrder();
    }

    @Override
    public Order findCartForCustomer(Customer customer) {
        return this.orderDao.readCartForCustomer(customer);
    }

    @Override
    public List<Order> findOrdersForCustomer(Customer customer) {
        return this.orderDao.readOrdersForCustomer(customer.getId());
    }

    @Override
    public List<Order> findOrdersForCustomer(Customer customer, OrderStatus status) {
        return this.orderDao.readOrdersForCustomer(customer, status);
    }

    @Override
    public Order findOrderByOrderNumber(String orderNumber) {
        return this.orderDao.readOrderByOrderNumber(orderNumber);
    }

    @Override
    public List<OrderPayment> findPaymentsForOrder(Order order) {
        return this.paymentDao.readPaymentsForOrder(order);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public OrderPayment addPaymentToOrder(Order order, OrderPayment payment, Referenced securePaymentInfo) {
        payment.setOrder(order);
        order.getPayments().add(payment);
        order = this.persist(order);
        int paymentIndex = order.getPayments().size() - 1;
        if (securePaymentInfo != null) {
            this.securePaymentInfoService.save(securePaymentInfo);
        }
        return order.getPayments().get(paymentIndex);
    }

    @Override
    public Order save(Order order, Boolean priceOrder) throws PricingException {
        TransactionStatus status = TransactionUtils.createTransaction((String)"saveOrder", (int)0, (PlatformTransactionManager)this.transactionManager);
        try {
            order = this.persist(order);
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
        }
        catch (RuntimeException ex) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw ex;
        }
        if (priceOrder.booleanValue()) {
            int retryCount = 0;
            boolean isValid = false;
            while (!isValid) {
                try {
                    order = this.pricingService.executePricing(order);
                    isValid = true;
                }
                catch (Exception ex) {
                    boolean isValidCause = false;
                    Throwable cause = ex;
                    while (!isValidCause) {
                        if (cause.getClass().equals(LockAcquisitionException.class)) {
                            isValidCause = true;
                        }
                        if ((cause = cause.getCause()) != null) continue;
                    }
                    if (isValidCause) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"Problem acquiring lock during pricing call - attempting to price again.");
                        }
                        isValid = false;
                        if (retryCount >= this.pricingRetryCountForLockFailure) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("Problem acquiring lock during pricing call. Retry limit exceeded at (" + retryCount + "). Throwing exception."));
                            }
                            if (ex instanceof PricingException) {
                                throw (PricingException)ex;
                            }
                            throw new PricingException(ex);
                        }
                        order = this.findOrderById(order.getId());
                        ++retryCount;
                        try {
                            Thread.sleep(this.pricingRetryWaitIntervalForLockFailure);
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    if (ex instanceof PricingException) {
                        throw (PricingException)ex;
                    }
                    throw new PricingException(ex);
                }
            }
            status = TransactionUtils.createTransaction((String)"saveOrder", (int)0, (PlatformTransactionManager)this.transactionManager);
            try {
                order = this.persist(order);
                TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
            }
            catch (RuntimeException ex) {
                TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
                throw ex;
            }
        }
        return order;
    }

    protected Order persist(Order order) {
        return this.orderDao.save(order);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void cancelOrder(Order order) {
        this.orderDao.delete(order);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void deleteOrder(Order order) {
        this.orderMultishipOptionService.deleteAllOrderMultishipOptions(order);
        this.orderDao.delete(order);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order addOfferCode(Order order, OfferCode offerCode, boolean priceOrder) throws PricingException, OfferMaxUseExceededException {
        ArrayList<OfferCode> offerCodes = new ArrayList<OfferCode>();
        offerCodes.add(offerCode);
        return this.addOfferCodes(order, offerCodes, priceOrder);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order addOfferCodes(Order order, List<OfferCode> offerCodes, boolean priceOrder) throws PricingException, OfferMaxUseExceededException {
        this.preValidateCartOperation(order);
        Set<Offer> addedOffers = this.offerService.getUniqueOffersFromOrder(order);
        if (offerCodes != null && !offerCodes.isEmpty()) {
            for (OfferCode offerCode : offerCodes) {
                if (order.getAddedOfferCodes().contains(offerCode) || addedOffers.contains(offerCode.getOffer())) continue;
                if (!this.offerService.verifyMaxCustomerUsageThreshold(order.getCustomer(), offerCode)) {
                    throw new OfferMaxUseExceededException("The customer has used this offer code more than the maximum allowed number of times.");
                }
                order.getAddedOfferCodes().add(offerCode);
            }
            order = this.save(order, priceOrder);
        }
        return order;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order removeOfferCode(Order order, OfferCode offerCode, boolean priceOrder) throws PricingException {
        order.getAddedOfferCodes().remove(offerCode);
        order = this.save(order, priceOrder);
        return order;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order removeAllOfferCodes(Order order, boolean priceOrder) throws PricingException {
        order.getAddedOfferCodes().clear();
        order = this.save(order, priceOrder);
        return order;
    }

    @Override
    @ManagedAttribute(description="The delete empty named order after adding items to cart attribute", currencyTimeLimit=15)
    public void setDeleteEmptyNamedOrders(boolean deleteEmptyNamedOrders) {
        this.deleteEmptyNamedOrders = deleteEmptyNamedOrders;
    }

    @Override
    public OrderItem findLastMatchingItem(Order order, Long skuId, Long productId) {
        if (order.getOrderItems() != null) {
            for (int i = order.getOrderItems().size() - 1; i >= 0; --i) {
                OrderItem currentItem = order.getOrderItems().get(i);
                if (currentItem instanceof DiscreteOrderItem) {
                    DiscreteOrderItem discreteItem = (DiscreteOrderItem)currentItem;
                    if (!(skuId != null ? discreteItem.getSku() != null && skuId.equals(discreteItem.getSku().getId()) : productId != null && discreteItem.getProduct() != null && productId.equals(discreteItem.getProduct().getId()))) continue;
                    return discreteItem;
                }
                if (!(currentItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleItem = (BundleOrderItem)currentItem;
                if (!(skuId != null ? bundleItem.getSku() != null && skuId.equals(bundleItem.getSku().getId()) : productId != null && bundleItem.getProduct() != null && productId.equals(bundleItem.getProduct().getId()))) continue;
                return bundleItem;
            }
        }
        return null;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order confirmOrder(Order order) {
        return this.orderDao.submitOrder(order);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order addAllItemsFromNamedOrder(Order namedOrder, boolean priceOrder) throws RemoveFromCartException, AddToCartException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        ArrayList<OrderItem> items = new ArrayList<OrderItem>(namedOrder.getOrderItems());
        for (OrderItem item : items) {
            if (this.moveNamedOrderItems) {
                this.removeItem(namedOrder.getId(), item.getId(), false);
            }
            OrderItemRequestDTO orderItemRequest = this.orderItemService.buildOrderItemRequestDTOFromOrderItem(item);
            cartOrder = this.addItem(cartOrder.getId(), orderItemRequest, priceOrder);
        }
        if (this.deleteEmptyNamedOrders) {
            this.cancelOrder(namedOrder);
        }
        return cartOrder;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order addItemFromNamedOrder(Order namedOrder, OrderItem item, boolean priceOrder) throws RemoveFromCartException, AddToCartException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        if (this.moveNamedOrderItems) {
            this.removeItem(namedOrder.getId(), item.getId(), false);
        }
        OrderItemRequestDTO orderItemRequest = this.orderItemService.buildOrderItemRequestDTOFromOrderItem(item);
        cartOrder = this.addItem(cartOrder.getId(), orderItemRequest, priceOrder);
        if (namedOrder.getOrderItems().size() == 0 && this.deleteEmptyNamedOrders) {
            this.cancelOrder(namedOrder);
        }
        return cartOrder;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order addItemFromNamedOrder(Order namedOrder, OrderItem item, int quantity, boolean priceOrder) throws RemoveFromCartException, AddToCartException, UpdateCartException {
        if (quantity < 1 || quantity > item.getQuantity()) {
            throw new IllegalArgumentException("Cannot move 0 or less quantity");
        }
        if (quantity == item.getQuantity()) {
            return this.addItemFromNamedOrder(namedOrder, item, priceOrder);
        }
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        if (this.moveNamedOrderItems) {
            OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
            orderItemRequestDTO.setOrderItemId(item.getId());
            orderItemRequestDTO.setQuantity(item.getQuantity() - quantity);
            this.updateItemQuantity(namedOrder.getId(), orderItemRequestDTO, false);
        }
        OrderItemRequestDTO orderItemRequest = this.orderItemService.buildOrderItemRequestDTOFromOrderItem(item);
        orderItemRequest.setQuantity(quantity);
        cartOrder = this.addItem(cartOrder.getId(), orderItemRequest, priceOrder);
        return cartOrder;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public OrderItem addGiftWrapItemToOrder(Order order, GiftWrapOrderItemRequest itemRequest, boolean priceOrder) throws PricingException {
        GiftWrapOrderItem item = this.orderItemService.createGiftWrapOrderItem(itemRequest);
        item.setOrder(order);
        item = (GiftWrapOrderItem)this.orderItemService.saveOrderItem(item);
        order.getOrderItems().add(item);
        order = this.save(order, priceOrder);
        return item;
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={AddToCartException.class})
    public Order addItem(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws AddToCartException {
        orderItemRequestDTO.setOverrideRetailPrice(null);
        orderItemRequestDTO.setOverrideSalePrice(null);
        return this.addItemWithPriceOverrides(orderId, orderItemRequestDTO, priceOrder);
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={AddToCartException.class})
    public Order addItemWithPriceOverrides(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws AddToCartException {
        OrderItem item;
        Order order = this.findOrderById(orderId);
        this.preValidateCartOperation(order);
        if (this.automaticallyMergeLikeItems && (item = this.findMatchingItem(order, orderItemRequestDTO)) != null) {
            orderItemRequestDTO.setQuantity(item.getQuantity() + orderItemRequestDTO.getQuantity());
            orderItemRequestDTO.setOrderItemId(item.getId());
            try {
                return this.updateItemQuantity(orderId, orderItemRequestDTO, priceOrder);
            }
            catch (RemoveFromCartException e) {
                throw new AddToCartException("Unexpected error - system tried to remove item while adding to cart", e);
            }
            catch (UpdateCartException e) {
                throw new AddToCartException("Could not update quantity for matched item", e);
            }
        }
        try {
            int numAdditionRequests = priceOrder ? 1 + orderItemRequestDTO.getChildOrderItems().size() : -1;
            int currentAddition = 1;
            CartOperationRequest cartOpRequest = new CartOperationRequest(this.findOrderById(orderId), orderItemRequestDTO, currentAddition == numAdditionRequests);
            ProcessContext<?> context = this.addItemWorkflow.doActivities(cartOpRequest);
            ArrayList<ActivityMessageDTO> orderMessages = new ArrayList<ActivityMessageDTO>();
            orderMessages.addAll(((ActivityMessages)((Object)context)).getActivityMessages());
            if (CollectionUtils.isNotEmpty(orderItemRequestDTO.getChildOrderItems())) {
                for (OrderItemRequestDTO childRequest : orderItemRequestDTO.getChildOrderItems()) {
                    childRequest.setParentOrderItemId(((CartOperationRequest)context.getSeedData()).getOrderItem().getId());
                    CartOperationRequest childCartOpRequest = new CartOperationRequest(((CartOperationRequest)context.getSeedData()).getOrder(), childRequest, ++currentAddition == numAdditionRequests);
                    ProcessContext<?> childContext = this.addItemWorkflow.doActivities(childCartOpRequest);
                    orderMessages.addAll(((ActivityMessages)((Object)childContext)).getActivityMessages());
                }
            }
            ((CartOperationRequest)context.getSeedData()).getOrder().setOrderMessages(orderMessages);
            return ((CartOperationRequest)context.getSeedData()).getOrder();
        }
        catch (WorkflowException e) {
            throw new AddToCartException("Could not add to cart", this.getCartOperationExceptionRootCause(e));
        }
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={UpdateCartException.class, RemoveFromCartException.class})
    public Order updateItemQuantity(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws UpdateCartException, RemoveFromCartException {
        this.preValidateCartOperation(this.findOrderById(orderId));
        if (orderItemRequestDTO.getQuantity() == 0) {
            return this.removeItem(orderId, orderItemRequestDTO.getOrderItemId(), priceOrder);
        }
        try {
            CartOperationRequest cartOpRequest = new CartOperationRequest(this.findOrderById(orderId), orderItemRequestDTO, priceOrder);
            ProcessContext<?> context = this.updateItemWorkflow.doActivities(cartOpRequest);
            ((CartOperationRequest)context.getSeedData()).getOrder().getOrderMessages().addAll(((ActivityMessages)((Object)context)).getActivityMessages());
            return ((CartOperationRequest)context.getSeedData()).getOrder();
        }
        catch (WorkflowException e) {
            throw new UpdateCartException("Could not update cart quantity", this.getCartOperationExceptionRootCause(e));
        }
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={RemoveFromCartException.class})
    public Order removeItem(Long orderId, Long orderItemId, boolean priceOrder) throws RemoveFromCartException {
        this.preValidateCartOperation(this.findOrderById(orderId));
        try {
            OrderItem oi = this.orderItemService.readOrderItemById(orderItemId);
            if (oi == null) {
                throw new WorkflowException(new ItemNotFoundException());
            }
            if (CollectionUtils.isNotEmpty(oi.getChildOrderItems())) {
                ArrayList<Long> childrenToRemove = new ArrayList<Long>();
                for (OrderItem childOrderItem : oi.getChildOrderItems()) {
                    childrenToRemove.add(childOrderItem.getId());
                }
                for (Long childToRemove : childrenToRemove) {
                    this.removeItemInternal(orderId, childToRemove, false);
                }
            }
            return this.removeItemInternal(orderId, orderItemId, priceOrder);
        }
        catch (WorkflowException e) {
            throw new RemoveFromCartException("Could not remove from cart", this.getCartOperationExceptionRootCause(e));
        }
    }

    protected Order removeItemInternal(Long orderId, Long orderItemId, boolean priceOrder) throws WorkflowException {
        OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
        orderItemRequestDTO.setOrderItemId(orderItemId);
        CartOperationRequest cartOpRequest = new CartOperationRequest(this.findOrderById(orderId), orderItemRequestDTO, priceOrder);
        ProcessContext<?> context = this.removeItemWorkflow.doActivities(cartOpRequest);
        ((CartOperationRequest)context.getSeedData()).getOrder().getOrderMessages().addAll(((ActivityMessages)((Object)context)).getActivityMessages());
        return ((CartOperationRequest)context.getSeedData()).getOrder();
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={RemoveFromCartException.class})
    public Order removeInactiveItems(Long orderId, boolean priceOrder) throws RemoveFromCartException {
        Order order = this.findOrderById(orderId);
        try {
            for (OrderItem currentItem : new ArrayList<OrderItem>(order.getOrderItems())) {
                if (currentItem.isSkuActive()) continue;
                this.removeItem(orderId, currentItem.getId(), priceOrder);
            }
        }
        catch (Exception e) {
            throw new RemoveFromCartException("Could not remove from cart", e.getCause());
        }
        return this.findOrderById(orderId);
    }

    @Override
    public boolean getAutomaticallyMergeLikeItems() {
        return this.automaticallyMergeLikeItems;
    }

    @Override
    public void setAutomaticallyMergeLikeItems(boolean automaticallyMergeLikeItems) {
        this.automaticallyMergeLikeItems = automaticallyMergeLikeItems;
    }

    @Override
    @ManagedAttribute(description="The move item from named order when adding to the cart attribute", currencyTimeLimit=15)
    public boolean isMoveNamedOrderItems() {
        return this.moveNamedOrderItems;
    }

    @Override
    @ManagedAttribute(description="The move item from named order when adding to the cart attribute", currencyTimeLimit=15)
    public void setMoveNamedOrderItems(boolean moveNamedOrderItems) {
        this.moveNamedOrderItems = moveNamedOrderItems;
    }

    @Override
    @ManagedAttribute(description="The delete empty named order after adding items to cart attribute", currencyTimeLimit=15)
    public boolean isDeleteEmptyNamedOrders() {
        return this.deleteEmptyNamedOrders;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void removeAllPaymentsFromOrder(Order order) {
        this.removePaymentsFromOrder(order, null);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void removePaymentsFromOrder(Order order, PaymentType paymentInfoType) {
        ArrayList<OrderPayment> infos = new ArrayList<OrderPayment>();
        for (OrderPayment paymentInfo : order.getPayments()) {
            if (paymentInfoType != null && !paymentInfoType.equals((Object)paymentInfo.getType())) continue;
            infos.add(paymentInfo);
        }
        order.getPayments().removeAll(infos);
        for (OrderPayment paymentInfo : infos) {
            try {
                this.securePaymentInfoService.findAndRemoveSecurePaymentInfo(paymentInfo.getReferenceNumber(), paymentInfo.getType());
            }
            catch (WorkflowException e) {
                LOG.debug((Object)"No secure payment is associated with the OrderPayment", (Throwable)((Object)e));
            }
            order.getPayments().remove(paymentInfo);
            paymentInfo = this.paymentDao.readPaymentById(paymentInfo.getId());
            this.paymentDao.delete(paymentInfo);
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void removePaymentFromOrder(Order order, OrderPayment payment) {
        OrderPayment paymentToRemove = null;
        for (OrderPayment info : order.getPayments()) {
            if (!info.equals(payment)) continue;
            paymentToRemove = info;
        }
        if (paymentToRemove != null) {
            try {
                this.securePaymentInfoService.findAndRemoveSecurePaymentInfo(paymentToRemove.getReferenceNumber(), payment.getType());
            }
            catch (WorkflowException e) {
                LOG.debug((Object)"No secure payment is associated with the OrderPayment", (Throwable)((Object)e));
            }
            order.getPayments().remove(paymentToRemove);
            payment = this.paymentDao.readPaymentById(paymentToRemove.getId());
            this.paymentDao.delete(payment);
        }
    }

    protected Throwable getCartOperationExceptionRootCause(WorkflowException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        Throwable currentCause = cause;
        while (currentCause.getCause() != null) {
            if (!((currentCause = currentCause.getCause()) instanceof WorkflowException)) continue;
            cause = currentCause.getCause();
        }
        return cause;
    }

    protected boolean compareAttributes(Map<String, OrderItemAttribute> item1Attributes, OrderItemRequestDTO item2) {
        int item2AttributeSize;
        int item1AttributeSize = item1Attributes == null ? 0 : item1Attributes.size();
        int n = item2AttributeSize = item2.getItemAttributes() == null ? 0 : item2.getItemAttributes().size();
        if (item1AttributeSize != item2AttributeSize) {
            return false;
        }
        for (String key : item2.getItemAttributes().keySet()) {
            String itemOneValue;
            String string = itemOneValue = item1Attributes.get(key) == null ? null : (String)((Object)item1Attributes.get(key).getValue());
            String itemTwoValue = item2.getItemAttributes().get(key);
            if (itemTwoValue.equals(itemOneValue)) continue;
            return false;
        }
        return true;
    }

    protected boolean itemMatches(Sku item1Sku, Product item1Product, Map<String, OrderItemAttribute> item1Attributes, OrderItemRequestDTO item2) {
        if (item1Sku != null && item2.getSkuId() != null) {
            if (item1Sku.getId().equals(item2.getSkuId())) {
                return true;
            }
        } else if (item1Product != null && item2.getProductId() != null && item1Product.getId().equals(item2.getProductId())) {
            return this.compareAttributes(item1Attributes, item2);
        }
        return false;
    }

    protected OrderItem findMatchingItem(Order order, OrderItemRequestDTO itemToFind) {
        if (order == null) {
            return null;
        }
        for (OrderItem currentItem : order.getOrderItems()) {
            BundleOrderItem bundleItem;
            if (currentItem instanceof DiscreteOrderItem) {
                DiscreteOrderItem discreteItem = (DiscreteOrderItem)currentItem;
                if (!this.itemMatches(discreteItem.getSku(), discreteItem.getProduct(), discreteItem.getOrderItemAttributes(), itemToFind)) continue;
                return discreteItem;
            }
            if (!(currentItem instanceof BundleOrderItem) || !this.itemMatches((bundleItem = (BundleOrderItem)currentItem).getSku(), bundleItem.getProduct(), null, itemToFind)) continue;
            return bundleItem;
        }
        return null;
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={UpdateCartException.class})
    public Order updateProductOptionsForItem(Long orderId, OrderItemRequestDTO orderItemRequestDTO, boolean priceOrder) throws UpdateCartException {
        try {
            CartOperationRequest cartOpRequest = new CartOperationRequest(this.findOrderById(orderId), orderItemRequestDTO, priceOrder);
            ProcessContext<?> context = this.updateProductOptionsForItemWorkflow.doActivities(cartOpRequest);
            ((CartOperationRequest)context.getSeedData()).getOrder().getOrderMessages().addAll(((ActivityMessages)((Object)context)).getActivityMessages());
            return ((CartOperationRequest)context.getSeedData()).getOrder();
        }
        catch (WorkflowException e) {
            throw new UpdateCartException("Could not product options", this.getCartOperationExceptionRootCause(e));
        }
    }

    @Override
    public Order reloadOrder(Order order) {
        if (order == null || order instanceof NullOrderImpl || order.getId() == null) {
            return order;
        }
        return this.orderDao.readOrderById(order.getId(), true);
    }

    @Override
    public void printOrder(Order order, Log log) {
        if (!log.isDebugEnabled()) {
            return;
        }
        TableCreator tc = new TableCreator(new TableCreator.Col[]{new TableCreator.Col("Order Item", 30), new TableCreator.Col("Qty"), new TableCreator.Col("Unit Price"), new TableCreator.Col("Avg Adj"), new TableCreator.Col("Total Adj"), new TableCreator.Col("Total Price")});
        for (OrderItem oi : order.getOrderItems()) {
            tc.addRow((Object[])new String[]{oi.getName(), String.valueOf(oi.getQuantity()), String.valueOf(oi.getPriceBeforeAdjustments(true)), String.valueOf(oi.getAverageAdjustmentValue()), String.valueOf(oi.getTotalAdjustmentValue()), String.valueOf(oi.getTotalPrice())});
        }
        tc.addSeparator().withGlobalRowHeaderWidth(15).addRow("Subtotal", (Object)order.getSubTotal()).addRow("Order Adj.", (Object)order.getOrderAdjustmentsValue()).addRow("Tax", (Object)order.getTotalTax()).addRow("Shipping", (Object)order.getTotalShipping()).addRow("Total", (Object)order.getTotal()).addSeparator();
        log.debug((Object)tc.toString());
    }

    @Override
    public void preValidateCartOperation(Order cart) {
        ExtensionResultHolder erh = new ExtensionResultHolder();
        ((OrderServiceExtensionHandler)this.extensionManager.getProxy()).preValidateCartOperation(cart, erh);
        if (erh.getThrowable() instanceof IllegalCartOperationException) {
            throw (IllegalCartOperationException)erh.getThrowable();
        }
        if (erh.getThrowable() != null) {
            throw new RuntimeException(erh.getThrowable());
        }
    }
}

