/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.inventory.service.ContextualInventoryService;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;

public class DecrementInventoryActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    @Resource(name="blInventoryService")
    protected ContextualInventoryService inventoryService;

    public DecrementInventoryActivity() {
        super.setAutomaticallyRegisterRollbackHandler(false);
    }

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        CheckoutSeed seed = context.getSeedData();
        List<OrderItem> orderItems = seed.getOrder().getOrderItems();
        HashMap<Sku, Integer> skuInventoryMap = new HashMap<Sku, Integer>();
        for (OrderItem orderItem : orderItems) {
            if (orderItem instanceof DiscreteOrderItem) {
                Sku sku = ((DiscreteOrderItem)orderItem).getSku();
                Integer quantity = (Integer)skuInventoryMap.get(sku);
                quantity = quantity == null ? Integer.valueOf(orderItem.getQuantity()) : Integer.valueOf(quantity + orderItem.getQuantity());
                if (!InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) continue;
                skuInventoryMap.put(sku, quantity);
                continue;
            }
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleItem = (BundleOrderItem)orderItem;
            if (InventoryType.CHECK_QUANTITY.equals(bundleItem.getSku().getInventoryType())) {
                skuInventoryMap.put(bundleItem.getSku(), bundleItem.getQuantity());
            }
            List<DiscreteOrderItem> discreteItems = bundleItem.getDiscreteOrderItems();
            for (DiscreteOrderItem discreteItem : discreteItems) {
                if (!InventoryType.CHECK_QUANTITY.equals(discreteItem.getSku().getInventoryType())) continue;
                Integer quantity = skuInventoryMap.get(discreteItem.getSku().getId());
                quantity = quantity == null ? Integer.valueOf(discreteItem.getQuantity() * bundleItem.getQuantity()) : Integer.valueOf(quantity + discreteItem.getQuantity() * bundleItem.getQuantity());
                skuInventoryMap.put(discreteItem.getSku(), quantity);
            }
        }
        HashMap<String, Object> rollbackState = new HashMap<String, Object>();
        if (this.getRollbackHandler() != null && !this.getAutomaticallyRegisterRollbackHandler()) {
            if (this.getStateConfiguration() != null && !this.getStateConfiguration().isEmpty()) {
                rollbackState.putAll(this.getStateConfiguration());
            }
            ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackRegion(), this.getRollbackHandler(), rollbackState);
        }
        if (!skuInventoryMap.isEmpty()) {
            HashMap<String, Object> contextualInfo = new HashMap<String, Object>();
            contextualInfo.put("ORDER", context.getSeedData().getOrder());
            contextualInfo.put("ROLLBACK_STATE", new HashMap());
            this.inventoryService.decrementInventory(skuInventoryMap, contextualInfo);
            if (this.getRollbackHandler() != null && !this.getAutomaticallyRegisterRollbackHandler()) {
                rollbackState.put("ROLLBACK_BLC_INVENTORY_DECREMENTED", skuInventoryMap);
                rollbackState.put("ROLLBACK_BLC_ORDER_ID", seed.getOrder().getId());
            }
            rollbackState.put("BLC_EXTENDED_ROLLBACK_STATE", contextualInfo.get("ROLLBACK_STATE"));
        }
        return context;
    }
}

