/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.store.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.store.dao.StoreDao;
import org.broadleafcommerce.core.store.domain.Store;
import org.broadleafcommerce.core.store.domain.StoreImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blStoreDao")
public class StoreDaoImpl
implements StoreDao {
    @PersistenceContext(unitName="blPU")
    private EntityManager em;

    @Override
    public Store readStoreById(Long id) {
        return (Store)this.em.find(StoreImpl.class, (Object)id);
    }

    @Override
    public Store readStoreByStoreName(String storeName) {
        Query query = this.em.createNamedQuery("BC_FIND_STORE_BY_STORE_NAME");
        query.setParameter("storeName", (Object)storeName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        List result = query.getResultList();
        return result.size() > 0 ? (Store)result.get(0) : null;
    }

    @Override
    public Store readStoreByStoreCode(String storeCode) {
        Query query = this.em.createNamedQuery("BC_FIND_STORE_BY_STORE_NAME");
        query.setParameter("storeName", (Object)storeCode.toUpperCase());
        query.setHint("org.hibernate.cacheable", (Object)true);
        List result = query.getResultList();
        return result.size() > 0 ? (Store)result.get(0) : null;
    }

    @Override
    public List<Store> readAllStores() {
        Query query = this.em.createNamedQuery("BC_FIND_ALL_STORES");
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Store> readAllStoresByState(String state) {
        Query query = this.em.createNamedQuery("BC_FIND_ALL_STORES_BY_STATE");
        query.setParameter("state", (Object)state);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }
}

