/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.redirect.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.core.search.redirect.domain.SearchRedirect;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SEARCH_INTERCEPT")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="SearchRedirectImpl_friendyName")
public class SearchRedirectImpl
implements SearchRedirect,
Serializable {
    private static final long serialVersionUID = 1L;
    @Transient
    private static final Log LOG = LogFactory.getLog(SearchRedirectImpl.class);
    @Id
    @GeneratedValue(generator="SearchRedirectID")
    @GenericGenerator(name="SearchRedirectID", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SearchRedirectImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.search.redirect.domain.SearchRedirectImpl")})
    @Column(name="SEARCH_REDIRECT_ID")
    @AdminPresentation(friendlyName="SearchRedirectImpl_ID", order=1, group="SearchRedirectImpl_description", groupOrder=1, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="PRIORITY")
    @AdminPresentation(friendlyName="SearchRedirectImpl_searchPriority", order=1, group="SearchRedirectImpl_description", groupOrder=1, prominent=true)
    @Index(name="SEARCH_PRIORITY_INDEX", columnNames={"PRIORITY"})
    protected Integer searchPriority;
    @AdminPresentation(friendlyName="SearchRedirectImpl_searchTerm", order=2, group="SearchRedirectImpl_description", prominent=true, groupOrder=1)
    @Column(name="SEARCH_TERM", nullable=false)
    protected String searchTerm;
    @Column(name="URL", nullable=false)
    @AdminPresentation(friendlyName="SearchRedirectImpl_url", order=3, group="SearchRedirectImpl_description", prominent=true, groupOrder=1)
    protected String url;
    @Column(name="ACTIVE_START_DATE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_Start_Date", order=7, group="SearchRedirectImpl_description", tooltip="skuStartDateTooltip", groupOrder=1)
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @Index(name="SEARCH_ACTIVE_INDEX", columnNames={"ACTIVE_START_DATE", "ACTIVE_END_DATE"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_End_Date", order=8, group="SearchRedirectImpl_description", tooltip="skuEndDateTooltip", groupOrder=1)
    protected Date activeEndDate;

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getSearchTerm() {
        return this.searchTerm;
    }

    @Override
    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Integer getSearchPriority() {
        return this.searchPriority;
    }

    @Override
    public void setSearchPriority(Integer searchPriority) {
        this.searchPriority = searchPriority;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
            LOG.debug((Object)("product, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true);
    }
}

