/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.search.domain.SearchSynonym;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_SEARCH_SYNONYM")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class SearchSynonymImpl
implements SearchSynonym {
    @Id
    @GeneratedValue(generator="SearchSynonymId")
    @GenericGenerator(name="SearchSynonymId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SearchSynonymImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.search.domain.SearchSynonymImpl")})
    @Column(name="SEARCH_SYNONYM_ID")
    private Long id;
    @Column(name="TERM")
    @Index(name="SEARCHSYNONYM_TERM_INDEX", columnNames={"TERM"})
    private String term;
    @Column(name="SYNONYMS")
    private String synonyms;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getTerm() {
        return this.term;
    }

    @Override
    public void setTerm(String term) {
        this.term = term;
    }

    @Override
    public String[] getSynonyms() {
        return this.synonyms.split("|");
    }

    @Override
    public void setSynonyms(String[] synonyms) {
        this.synonyms = StringUtils.join((Object[])synonyms, (char)'|');
    }
}

