/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.core.rating.domain.RatingDetail;
import org.broadleafcommerce.core.rating.domain.RatingDetailImpl;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.domain.ReviewDetailImpl;
import org.broadleafcommerce.core.rating.service.type.RatingType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_RATING_SUMMARY")
public class RatingSummaryImpl
implements RatingSummary {
    @Id
    @GeneratedValue(generator="RatingSummaryId")
    @GenericGenerator(name="RatingSummaryId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="RatingSummaryImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.rating.domain.RatingSummaryImpl")})
    @Column(name="RATING_SUMMARY_ID")
    protected Long id;
    @Column(name="ITEM_ID", nullable=false)
    @Index(name="RATINGSUMM_ITEM_INDEX", columnNames={"ITEM_ID"})
    protected String itemId;
    @Column(name="RATING_TYPE", nullable=false)
    @Index(name="RATINGSUMM_TYPE_INDEX", columnNames={"RATING_TYPE"})
    protected String ratingTypeStr;
    @Column(name="AVERAGE_RATING", nullable=false)
    protected Double averageRating = new Double(0.0);
    @OneToMany(mappedBy="ratingSummary", targetEntity=RatingDetailImpl.class, cascade={CascadeType.ALL})
    protected List<RatingDetail> ratings = new ArrayList<RatingDetail>();
    @OneToMany(mappedBy="ratingSummary", targetEntity=ReviewDetailImpl.class, cascade={CascadeType.ALL})
    protected List<ReviewDetail> reviews = new ArrayList<ReviewDetail>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Double getAverageRating() {
        return this.averageRating;
    }

    @Override
    public void resetAverageRating() {
        if (this.ratings == null || this.ratings.isEmpty()) {
            this.averageRating = new Double(0.0);
        } else {
            double sum = 0.0;
            for (RatingDetail detail : this.ratings) {
                sum += detail.getRating().doubleValue();
            }
            this.averageRating = new Double(sum / (double)this.ratings.size());
        }
    }

    @Override
    public String getItemId() {
        return this.itemId;
    }

    @Override
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    @Override
    public Integer getNumberOfRatings() {
        return this.getRatings().size();
    }

    @Override
    public Integer getNumberOfReviews() {
        return this.getReviews().size();
    }

    @Override
    public RatingType getRatingType() {
        return new RatingType(this.ratingTypeStr);
    }

    @Override
    public void setRatingType(RatingType type) {
        this.ratingTypeStr = type == null ? null : type.getType();
    }

    @Override
    public List<RatingDetail> getRatings() {
        return this.ratings == null ? new ArrayList() : this.ratings;
    }

    @Override
    public void setRatings(List<RatingDetail> ratings) {
        this.ratings = ratings;
    }

    @Override
    public List<ReviewDetail> getReviews() {
        return this.reviews == null ? new ArrayList() : this.reviews;
    }

    @Override
    public void setReviews(List<ReviewDetail> reviews) {
        this.reviews = reviews;
    }
}

