/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class AdjustOrderPaymentsActivity
extends BaseActivity<ProcessContext<Order>> {
    @Override
    public ProcessContext<Order> execute(ProcessContext<Order> context) throws Exception {
        Order order = context.getSeedData();
        OrderPayment unconfirmedThirdParty = null;
        Money appliedPaymentsWithoutThirdParty = Money.ZERO;
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            PaymentTransaction initialTransaction = payment.getInitialTransaction();
            if (initialTransaction != null && PaymentTransactionType.UNCONFIRMED.equals((Object)initialTransaction.getType()) && PaymentType.THIRD_PARTY_ACCOUNT.equals((Object)payment.getType())) {
                unconfirmedThirdParty = payment;
                continue;
            }
            if (payment.getAmount() == null) continue;
            appliedPaymentsWithoutThirdParty = appliedPaymentsWithoutThirdParty.add(payment.getAmount());
        }
        if (unconfirmedThirdParty != null) {
            Money difference = order.getTotal().subtract(appliedPaymentsWithoutThirdParty);
            unconfirmedThirdParty.setAmount(difference);
        }
        context.setSeedData(order);
        return context;
    }
}

