/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import javax.annotation.Resource;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.core.payment.dao.SecureOrderPaymentDao;
import org.broadleafcommerce.core.payment.domain.secure.BankAccountPayment;
import org.broadleafcommerce.core.payment.domain.secure.CreditCardPayment;
import org.broadleafcommerce.core.payment.domain.secure.GiftCardPayment;
import org.broadleafcommerce.core.payment.domain.secure.Referenced;
import org.broadleafcommerce.core.payment.service.SecureOrderPaymentService;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blSecureOrderPaymentService")
public class SecureOrderPaymentServiceImpl
implements SecureOrderPaymentService {
    @Resource(name="blSecureOrderPaymentDao")
    protected SecureOrderPaymentDao securePaymentInfoDao;

    @Override
    @Transactional(value="blTransactionManagerSecureInfo")
    public Referenced save(Referenced securePaymentInfo) {
        return this.securePaymentInfoDao.save(securePaymentInfo);
    }

    @Override
    public Referenced create(PaymentType paymentType) {
        if (paymentType.equals((Object)PaymentType.CREDIT_CARD)) {
            CreditCardPayment ccinfo = this.securePaymentInfoDao.createCreditCardPayment();
            return ccinfo;
        }
        if (paymentType.equals((Object)PaymentType.BANK_ACCOUNT)) {
            BankAccountPayment bankinfo = this.securePaymentInfoDao.createBankAccountPayment();
            return bankinfo;
        }
        if (paymentType.equals((Object)PaymentType.GIFT_CARD)) {
            GiftCardPayment gcinfo = this.securePaymentInfoDao.createGiftCardPayment();
            return gcinfo;
        }
        return null;
    }

    @Override
    public Referenced findSecurePaymentInfo(String referenceNumber, PaymentType paymentType) throws WorkflowException {
        if (paymentType == PaymentType.CREDIT_CARD) {
            CreditCardPayment ccinfo = this.findCreditCardInfo(referenceNumber);
            if (ccinfo == null) {
                throw new WorkflowException("No credit card info associated with credit card payment type with reference number: " + referenceNumber);
            }
            return ccinfo;
        }
        if (paymentType == PaymentType.BANK_ACCOUNT) {
            BankAccountPayment bankinfo = this.findBankAccountInfo(referenceNumber);
            if (bankinfo == null) {
                throw new WorkflowException("No bank account info associated with bank account payment type with reference number: " + referenceNumber);
            }
            return bankinfo;
        }
        if (paymentType == PaymentType.GIFT_CARD) {
            GiftCardPayment gcinfo = this.findGiftCardInfo(referenceNumber);
            if (gcinfo == null) {
                throw new WorkflowException("No bank account info associated with gift card payment type with reference number: " + referenceNumber);
            }
            return gcinfo;
        }
        return null;
    }

    @Override
    @Transactional(value="blTransactionManagerSecureInfo")
    public void findAndRemoveSecurePaymentInfo(String referenceNumber, PaymentType paymentType) throws WorkflowException {
        Referenced referenced = this.findSecurePaymentInfo(referenceNumber, paymentType);
        if (referenced != null) {
            this.remove(referenced);
        }
    }

    @Override
    @Transactional(value="blTransactionManagerSecureInfo")
    public void remove(Referenced securePaymentInfo) {
        this.securePaymentInfoDao.delete(securePaymentInfo);
    }

    protected BankAccountPayment findBankAccountInfo(String referenceNumber) {
        return this.securePaymentInfoDao.findBankAccountPayment(referenceNumber);
    }

    protected CreditCardPayment findCreditCardInfo(String referenceNumber) {
        return this.securePaymentInfoDao.findCreditCardPayment(referenceNumber);
    }

    protected GiftCardPayment findGiftCardInfo(String referenceNumber) {
        return this.securePaymentInfoDao.findGiftCardPayment(referenceNumber);
    }
}

