/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.update.options;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class UpdateProductOptionsOrderItemActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        CartOperationRequest request = context.getSeedData();
        OrderItemRequestDTO orderItemRequestDTO = request.getItemRequest();
        Order order = request.getOrder();
        if (this.orderItemService.readOrderItemById((long)orderItemRequestDTO.getOrderItemId()) != null) {
            DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
            itemRequest.setItemAttributes(orderItemRequestDTO.getItemAttributes());
            this.orderItemService.updateDiscreteOrderItem(this.orderItemService.readOrderItemById((long)orderItemRequestDTO.getOrderItemId()), itemRequest);
        }
        order = this.orderService.save(order, false);
        request.setOrder(order);
        return context;
    }
}

