/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.remove;

import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class RemoveOrderItemActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        CartOperationRequest request = context.getSeedData();
        OrderItem orderItem = request.getOrderItem();
        this.removeItemAndChildren(request.getOisToDelete(), orderItem);
        return context;
    }

    protected void removeItemAndChildren(List<OrderItem> oisToDelete, OrderItem orderItem) {
        if (CollectionUtils.isNotEmpty(orderItem.getChildOrderItems())) {
            for (OrderItem childOrderItem : orderItem.getChildOrderItems()) {
                this.removeItemAndChildren(oisToDelete, childOrderItem);
            }
        }
        oisToDelete.add(orderItem);
    }
}

