/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class OrderItemType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OrderItemType> TYPES = new LinkedHashMap<String, OrderItemType>();
    public static final OrderItemType BASIC = new OrderItemType("org.broadleafcommerce.core.order.domain.OrderItem", "Basic Order Item");
    public static final OrderItemType DISCRETE = new OrderItemType("org.broadleafcommerce.core.order.domain.DiscreteOrderItem", "Discrete Order Item");
    public static final OrderItemType EXTERNALLY_PRICED = new OrderItemType("org.broadleafcommerce.core.order.domain.DynamicPriceDiscreteOrderItem", "Externally Priced Discrete Order Item");
    public static final OrderItemType BUNDLE = new OrderItemType("org.broadleafcommerce.core.order.domain.BundleOrderItem", "Bundle Order Item");
    public static final OrderItemType GIFTWRAP = new OrderItemType("org.broadleafcommerce.core.order.domain.GiftWrapOrderItem", "Gift Wrap Order Item");
    private String type;
    private String friendlyType;

    public static OrderItemType getInstance(String type) {
        return TYPES.get(type);
    }

    public OrderItemType() {
    }

    public OrderItemType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemType other = (OrderItemType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

